package org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;


/**
 * Identity used to mark node context for Routed RPCs (determines the type of 
 * routing)
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>rpcbench-payload</b>
 * <br>(Source path: <i>META-INF/yang/rpcbench-payload.yang</i>):
 * <pre>
 * identity node-context {
 *     description
 *         "Identity used to mark node context for Routed RPCs (determines the type of routing)";
 *     status CURRENT;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>rpcbench-payload/node-context</i>
 *
 */
public abstract class NodeContext extends BaseIdentity
 {
    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("rpcbench-payload",
        "2015-07-02", "node-context").intern();


    public NodeContext() {
    
    
    }
    






}

