/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.tools.variant;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyOutputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.ga4gh.models.CallSet;
import org.ga4gh.models.Variant;
import org.ga4gh.models.VariantSet;
import org.opencb.biodata.formats.variant.vcf4.FullVcfCodec;
import org.opencb.hpg.bigdata.core.converters.variation.Genotype2CallSet;
import org.opencb.hpg.bigdata.core.converters.variation.VariantContext2VariantConverter;
import org.opencb.hpg.bigdata.core.converters.variation.VariantConverterContext;
import org.opencb.hpg.bigdata.core.io.VcfBlockIterator;
import org.opencb.hpg.bigdata.tools.utils.ChunkKey;
import org.opencb.hpg.bigdata.tools.utils.CompressionUtils;
import org.seqdoop.hadoop_bam.VCFInputFormat;
import org.seqdoop.hadoop_bam.VariantContextWritable;

public class Vcf2AvroMR {
    public static final String VARIANT_FILE = "variantfile";
    private static VariantConverterContext variantConverterContext;

    public static int run(String input, String output, String codecName) throws Exception {
        Configuration conf = new Configuration();
        if (input.endsWith(".gz")) {
            throw new UnsupportedOperationException("Unable to read gzip vcf");
        }
        conf.set(VARIANT_FILE, input);
        Job job = Job.getInstance((Configuration)conf, (String)"Vcf2AvroMR");
        job.setJarByClass(Vcf2AvroMR.class);
        job.getConfiguration().set("mapreduce.job.user.classpath.first", "true");
        AvroJob.setOutputKeySchema((Job)job, (Schema)Variant.getClassSchema());
        job.setOutputValueClass(NullWritable.class);
        AvroJob.setMapOutputValueSchema((Job)job, (Schema)Variant.getClassSchema());
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(input)});
        job.setInputFormatClass(VCFInputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(output));
        if (codecName != null) {
            FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
            FileOutputFormat.setOutputCompressorClass((Job)job, CompressionUtils.getHadoopCodec(codecName));
        }
        job.setOutputFormatClass(AvroKeyOutputFormat.class);
        job.setMapOutputKeyClass(ChunkKey.class);
        job.setMapOutputValueClass(AvroValue.class);
        job.setMapperClass(Vcf2AvroMapper.class);
        job.setReducerClass(Vcf2AvroReducer.class);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static class Vcf2AvroReducer
    extends Reducer<ChunkKey, AvroValue<Variant>, AvroKey<Variant>, NullWritable> {
        public void reduce(ChunkKey key, Iterable<AvroValue<Variant>> values, Reducer.Context context) throws IOException, InterruptedException {
            for (AvroValue<Variant> value : values) {
                context.write((Object)new AvroKey(value.datum()), (Object)NullWritable.get());
            }
        }
    }

    public static class Vcf2AvroMapper
    extends Mapper<LongWritable, VariantContextWritable, ChunkKey, AvroValue<Variant>> {
        private VariantContext2VariantConverter converter = new VariantContext2VariantConverter();
        private VCFHeader header;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            String input = context.getConfiguration().get(Vcf2AvroMR.VARIANT_FILE);
            FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
            try (FSDataInputStream inputStream = fs.open(new Path(input));
                 VcfBlockIterator iterator = new VcfBlockIterator((InputStream)inputStream, new FullVcfCodec());){
                this.header = iterator.getHeader();
            }
            int gtSize = this.header.getGenotypeSamples().size();
            variantConverterContext = new VariantConverterContext();
            VariantSet vs = new VariantSet();
            vs.setId("test");
            vs.setDatasetId("test");
            vs.setReferenceSetId("test");
            List genotypeSamples = this.header.getGenotypeSamples();
            Genotype2CallSet gtConverter = new Genotype2CallSet();
            for (int gtPos = 0; gtPos < gtSize; ++gtPos) {
                CallSet cs = gtConverter.forward((String)genotypeSamples.get(gtPos));
                cs.getVariantSetIds().add(vs.getId());
                variantConverterContext.getCallSetMap().put(cs.getName(), cs);
            }
            this.converter.setContext(variantConverterContext);
        }

        public void map(LongWritable key, VariantContextWritable value, Mapper.Context context) throws IOException, InterruptedException {
            VariantContext variantContext = value.get();
            int startChunk = variantContext.getStart() / 4000;
            int endChunk = variantContext.getEnd() / 4000;
            ChunkKey newKey = new ChunkKey(variantContext.getContig(), startChunk);
            Variant variant = this.converter.forward(variantContext);
            context.write((Object)newKey, (Object)new AvroValue((Object)variant));
        }
    }

    public static class VariantWritable
    extends Variant
    implements Writable {
        public void write(DataOutput dataOutput) throws IOException {
        }

        public void readFields(DataInput dataInput) throws IOException {
        }
    }
}

