/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.tools.variant;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.ga4gh.models.Call;
import org.ga4gh.models.Variant;
import org.opencb.hpg.bigdata.tools.utils.HBaseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Variant2HbaseMR
extends Mapper<AvroKey<Variant>, NullWritable, ImmutableBytesWritable, Put> {
    private static final String VARIANT_2_HBASE_EXPAND_REGIONS = "VARIANT_2_HBASE.EXPAND_REGIONS";
    private static final String VARIANT_2_HBASE_NON_VAR = "VARIANT_2_HBASE.NON_VARIANT";
    public static final byte[] COLUMN_FAMILY = Bytes.toBytes((String)"d");
    private static final Logger LOG = LoggerFactory.getLogger(Variant2HbaseMR.class);
    private Configuration config;
    private boolean expandRegions = false;
    private boolean nonVariant = false;

    public static Logger getLog() {
        return LOG;
    }

    public void setExpandRegions(boolean expandRegions) {
        this.expandRegions = expandRegions;
    }

    public boolean isExpandRegions() {
        return this.expandRegions;
    }

    public boolean isNonVariant() {
        return this.nonVariant;
    }

    public void setNonVariant(boolean nonVariant) {
        this.nonVariant = nonVariant;
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this.setExpandRegions(conf.getBoolean(VARIANT_2_HBASE_EXPAND_REGIONS, this.isExpandRegions()));
        this.setNonVariant(conf.getBoolean(VARIANT_2_HBASE_NON_VAR, this.isNonVariant()));
        super.setup(context);
    }

    protected void map(AvroKey<Variant> key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
        Variant variant = (Variant)key.datum();
        if (this.isReference(variant) && this.isNonVariant()) {
            String refplaceholder = "#";
            Long start = variant.getStart();
            Long endPos = start + 1L;
            List calls = variant.getCalls();
            boolean nocall = calls.isEmpty();
            if (this.isExpandRegions()) {
                context.getCounter("VCF", "REG_EXPAND" + (nocall ? "_NOCALL" : "")).increment(1L);
                Map info = variant.getInfo();
                List endLst = (List)info.get("END");
                if (null == endLst || endLst.isEmpty()) {
                    context.getCounter("VCF", "REF_END_EMPTY" + (nocall ? "_NOCALL" : "")).increment(1L);
                } else {
                    String endStr = ((String)endLst.get(0)).toString();
                    endPos = Long.valueOf(endStr);
                }
            }
            String counterName = "REG_EXPAND_CNT" + (nocall ? "_NOCALL" : "");
            context.getCounter("VCF", counterName).increment(endPos - start);
            if (!nocall) {
                for (long pos = start.longValue(); pos < endPos; ++pos) {
                    String idStr = HBaseUtils.buildRefernceStorageId(variant.getReferenceName(), pos, refplaceholder);
                    this.store(context, calls, idStr);
                }
            }
        } else {
            int altCnt = variant.getAlternateBases().size();
            if (altCnt > 1) {
                context.getCounter("VCF", "biallelic_COUNT").increment(1L);
                return;
            }
            List calls = variant.getCalls();
            if (null == calls || calls.isEmpty()) {
                context.getCounter("VCF", "NO_CALL_COUNT").increment(1L);
                return;
            }
            int altIdx = 0;
            String altBases = "-";
            if (altCnt > 0) {
                altBases = (String)variant.getAlternateBases().get(altIdx);
            }
            String refBases = variant.getReferenceBases();
            if (altBases.length() >= 50 || refBases.length() >= 50) {
                context.getCounter("VCF", "SV_COUNT").increment(1L);
                return;
            }
            String idStr = HBaseUtils.buildStorageId(variant.getReferenceName(), variant.getStart(), refBases, altBases);
            this.store(context, calls, idStr);
        }
    }

    private void store(Mapper.Context context, List<Call> calls, String idStr) throws IOException, InterruptedException {
        byte[] id = Bytes.toBytes((String)idStr);
        Put put = new Put(id);
        for (Call call : calls) {
            this.addEntry(put, call);
        }
        ImmutableBytesWritable rowKey = new ImmutableBytesWritable(id);
        context.write((Object)rowKey, (Object)put);
    }

    private boolean isReference(Variant variant) {
        return null == variant.getAlternateBases() || variant.getAlternateBases().isEmpty();
    }

    private void addEntry(Put put, Call call) {
        String id = call.getCallSetId();
        String idStr = id.toString();
        put.addColumn(COLUMN_FAMILY, Bytes.toBytes((String)idStr), Bytes.toBytes((String)call.toString()));
    }

    public void setConf(Configuration conf) {
        this.config = conf;
    }

    public Configuration getConf() {
        return this.config;
    }

    public static void createTableIfNeeded(String tablename, Configuration conf) throws IOException {
        if (HBaseUtils.createTableIfNeeded(tablename, COLUMN_FAMILY, conf)) {
            Variant2HbaseMR.getLog().info(String.format("Create table '%s' in hbase!", tablename));
        }
    }

    public static class Builder {
        private URI uri;
        private String inputfile;
        private boolean expand = false;
        private boolean non_var = false;

        public Builder(String inputfile, URI uri) {
            this.inputfile = inputfile;
            this.uri = uri;
        }

        public Builder setUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder setInputfile(String inputfile) {
            this.inputfile = inputfile;
            return this;
        }

        public Builder setExpand(boolean expand) {
            this.expand = expand;
            return this;
        }

        public Builder setNonVar(boolean nonVar) {
            this.non_var = nonVar;
            return this;
        }

        public Job build(boolean createTableIfNeeded) throws IOException {
            String inputfile = this.inputfile;
            String server = null;
            Integer port = 60000;
            String tablename = null;
            if (null == this.uri) {
                throw new IllegalArgumentException("No Server output specified!");
            }
            server = this.uri.getHost();
            if (StringUtils.isBlank((CharSequence)server)) {
                throw new IllegalArgumentException("No Server host name specified in URI: " + this.uri);
            }
            if (this.uri.getPort() > 0) {
                port = this.uri.getPort();
            }
            String master = String.join((CharSequence)":", server, port.toString());
            if (StringUtils.isBlank((CharSequence)this.uri.getPath()) || StringUtils.equals((CharSequence)this.uri.getPath().trim(), (CharSequence)"/")) {
                throw new IllegalArgumentException("No Table name specified in URI: " + this.uri);
            }
            tablename = this.uri.getPath();
            tablename = tablename.startsWith("/") ? tablename.substring(1) : tablename;
            Variant2HbaseMR.getLog().info(String.format("Loading data into server '%s' using table '%s' ", master, tablename));
            Configuration conf = new Configuration();
            conf.set("hbase.zookeeper.quorum", server);
            conf.set("hbase.master", master);
            conf.setBoolean(Variant2HbaseMR.VARIANT_2_HBASE_EXPAND_REGIONS, this.expand);
            conf.setBoolean(Variant2HbaseMR.VARIANT_2_HBASE_NON_VAR, this.non_var);
            conf = HBaseConfiguration.addHbaseResources((Configuration)conf);
            Class<Variant2HbaseMR> clazz = Variant2HbaseMR.class;
            Job job = Job.getInstance((Configuration)conf, (String)clazz.getName());
            job.setJarByClass(clazz);
            AvroJob.setInputKeySchema((Job)job, (Schema)Variant.getClassSchema());
            FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(inputfile)});
            job.setInputFormatClass(AvroKeyInputFormat.class);
            job.setNumReduceTasks(0);
            TableMapReduceUtil.initTableReducerJob((String)tablename, null, (Job)job);
            job.setMapperClass(Variant2HbaseMR.class);
            if (createTableIfNeeded) {
                Variant2HbaseMR.createTableIfNeeded(tablename, conf);
            }
            return job;
        }
    }
}

