/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.tools.utils;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.opencb.commons.utils.CryptoUtils;

public class HBaseUtils {
    public static final int SV_THRESHOLD = 50;
    public static final String ROWKEY_SEPARATOR = "_";

    public static String buildRefernceStorageId(CharSequence chr, Long start, CharSequence refBases) {
        return HBaseUtils.buildStorageId(chr, start, refBases, refBases);
    }

    public static String buildStorageId(CharSequence chr, Long start, CharSequence refBases, CharSequence altBases) {
        StringBuilder builder = new StringBuilder();
        builder.append(HBaseUtils.buildStoragePosition(chr, start));
        builder.append(ROWKEY_SEPARATOR);
        if (refBases.length() < 50) {
            builder.append(refBases);
        } else {
            builder.append(new String(CryptoUtils.encryptSha1((String)refBases.toString())));
        }
        builder.append(ROWKEY_SEPARATOR);
        if (altBases.length() < 50) {
            builder.append(altBases);
        } else {
            builder.append(new String(CryptoUtils.encryptSha1((String)altBases.toString())));
        }
        return builder.toString();
    }

    public static String buildStoragePosition(CharSequence chr, Long pos) {
        String chrom = chr.toString();
        if (chrom.length() > 2 && chrom.substring(0, 2).equals("chr")) {
            chrom = chrom.substring(2);
        }
        if (chrom.length() < 2) {
            chrom = "0" + chrom;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(chrom);
        builder.append(ROWKEY_SEPARATOR);
        builder.append(String.format("%012d", pos));
        return builder.toString();
    }

    public static boolean createTableIfNeeded(String tablename, byte[] columnFamily, Configuration configuration) throws IOException {
        TableName tname = TableName.valueOf((String)tablename);
        try (Connection con = ConnectionFactory.createConnection((Configuration)configuration);
             Table table = con.getTable(tname);
             Admin admin = con.getAdmin();){
            if (!HBaseUtils.exist(tname, admin)) {
                HTableDescriptor descr = new HTableDescriptor(tname);
                descr.addFamily(new HColumnDescriptor(columnFamily));
                admin.createTable(descr);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static boolean exist(TableName tname, Admin admin) throws IOException {
        for (TableName tn : admin.listTableNames()) {
            if (!tn.equals((Object)tname)) continue;
            return true;
        }
        return false;
    }
}

