/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.tools.utils;

import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DeflateCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.SnappyCodec;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public final class CompressionUtils {
    private CompressionUtils() {
    }

    public static Class<? extends CompressionCodec> getHadoopCodec(String name) {
        if (name == null) {
            return null;
        }
        if (name.equalsIgnoreCase("gzip")) {
            return GzipCodec.class;
        }
        if (name.equalsIgnoreCase("snappy")) {
            return SnappyCodec.class;
        }
        if (name.equalsIgnoreCase("bzip2")) {
            return BZip2Codec.class;
        }
        return DeflateCodec.class;
    }

    public static CompressionCodecName getParquetCodec(String name) {
        CompressionCodecName compressionCodecName;
        if (name == null || name.equalsIgnoreCase("null")) {
            return CompressionCodecName.UNCOMPRESSED;
        }
        switch (name) {
            case "snappy": {
                compressionCodecName = CompressionCodecName.SNAPPY;
                break;
            }
            case "gzip": {
                compressionCodecName = CompressionCodecName.GZIP;
                break;
            }
            case "lzo": {
                compressionCodecName = CompressionCodecName.LZO;
                break;
            }
            default: {
                compressionCodecName = CompressionCodecName.SNAPPY;
            }
        }
        return compressionCodecName;
    }
}

