/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.tools.sequence.stats;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hadoop.io.Writable;
import org.opencb.biodata.tools.sequence.tasks.SequenceInfo;
import org.opencb.biodata.tools.sequence.tasks.SequenceStats;

public class ReadStatsWritable
implements Writable {
    private SequenceStats stats;

    public ReadStatsWritable() {
    }

    public ReadStatsWritable(SequenceStats stats) {
        this.setStats(stats);
    }

    public void write(DataOutput out) throws IOException {
        int key;
        out.writeInt(this.stats.numSeqs);
        out.writeInt(this.stats.numA);
        out.writeInt(this.stats.numT);
        out.writeInt(this.stats.numG);
        out.writeInt(this.stats.numC);
        out.writeInt(this.stats.numN);
        out.writeInt(this.stats.minSeqLength);
        out.writeInt(this.stats.maxSeqLength);
        out.writeInt(this.stats.accSeqQual);
        out.writeInt(this.stats.lengthMap.size());
        Iterator iterator = this.stats.lengthMap.keySet().iterator();
        while (iterator.hasNext()) {
            key = (Integer)iterator.next();
            out.writeInt(key);
            out.writeInt((Integer)this.stats.lengthMap.get(key));
        }
        out.writeInt(this.stats.infoMap.size());
        iterator = this.stats.infoMap.keySet().iterator();
        while (iterator.hasNext()) {
            key = (Integer)iterator.next();
            out.writeInt(key);
            SequenceInfo info = (SequenceInfo)this.stats.infoMap.get(key);
            out.writeInt(info.numA);
            out.writeInt(info.numT);
            out.writeInt(info.numG);
            out.writeInt(info.numC);
            out.writeInt(info.numN);
            out.writeInt(info.numQual);
            out.writeInt(info.accQual);
        }
        out.writeInt(this.stats.kmers.kvalue);
        out.writeInt(this.stats.kmers.kmersMap.size());
        for (String key2 : this.stats.kmers.kmersMap.keySet()) {
            out.writeUTF(key2);
            out.writeInt((Integer)this.stats.kmers.kmersMap.get(key2));
        }
    }

    public void readFields(DataInput in) throws IOException {
        int i;
        this.stats = new SequenceStats();
        this.stats.numSeqs = in.readInt();
        this.stats.numA = in.readInt();
        this.stats.numT = in.readInt();
        this.stats.numG = in.readInt();
        this.stats.numC = in.readInt();
        this.stats.numN = in.readInt();
        this.stats.minSeqLength = in.readInt();
        this.stats.maxSeqLength = in.readInt();
        this.stats.accSeqQual = in.readInt();
        int size = in.readInt();
        this.stats.lengthMap = new HashMap(size);
        for (i = 0; i < size; ++i) {
            this.stats.lengthMap.put(in.readInt(), in.readInt());
        }
        size = in.readInt();
        this.stats.infoMap = new HashMap(size);
        for (i = 0; i < size; ++i) {
            int key = in.readInt();
            SequenceInfo info = new SequenceInfo();
            info.numA = in.readInt();
            info.numT = in.readInt();
            info.numG = in.readInt();
            info.numC = in.readInt();
            info.numN = in.readInt();
            info.numQual = in.readInt();
            info.accQual = in.readInt();
            this.stats.infoMap.put(key, info);
        }
        this.stats.kmers.kvalue = in.readInt();
        size = in.readInt();
        this.stats.kmers.kmersMap = new HashMap(size);
        for (i = 0; i < size; ++i) {
            this.stats.kmers.kmersMap.put(in.readUTF(), in.readInt());
        }
    }

    public SequenceStats getStats() {
        return this.stats;
    }

    public void setStats(SequenceStats stats) {
        this.stats = stats;
    }
}

