/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.tools.sequence.stats;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.io.Writable;
import org.opencb.biodata.tools.sequence.tasks.SequenceKmers;

public class ReadKmersWritable
implements Writable {
    private SequenceKmers kmers;

    public ReadKmersWritable() {
    }

    public ReadKmersWritable(SequenceKmers kmers) {
        this.setKmers(kmers);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.kmers.kvalue);
        out.writeInt(this.kmers.kmersMap.size());
        for (String key : this.kmers.kmersMap.keySet()) {
            out.writeUTF(key);
            out.writeInt((Integer)this.kmers.kmersMap.get(key));
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.kmers = new SequenceKmers(in.readInt());
        int size = in.readInt();
        this.kmers.kmersMap = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            this.kmers.kmersMap.put(in.readUTF(), in.readInt());
        }
    }

    public SequenceKmers getKmers() {
        return this.kmers;
    }

    public void setKmers(SequenceKmers kmers) {
        this.kmers = kmers;
    }
}

