/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.tools.sequence.stats;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hadoop.io.Writable;
import org.opencb.biodata.tools.alignment.tasks.AlignmentStats;
import org.opencb.biodata.tools.sequence.tasks.SequenceStats;
import org.opencb.hpg.bigdata.tools.sequence.stats.ReadStatsWritable;

public class ReadAlignmentStatsWritable
implements Writable {
    private AlignmentStats stats;

    public ReadAlignmentStatsWritable() {
    }

    public ReadAlignmentStatsWritable(AlignmentStats stats) {
        this.setStats(stats);
    }

    public AlignmentStats getStats() {
        return this.stats;
    }

    public void setStats(AlignmentStats stats) {
        this.stats = stats;
    }

    public void setSeqStats(SequenceStats seqStats) {
        this.stats.seqStats = seqStats;
    }

    public void write(DataOutput out) throws IOException {
        int key;
        out.writeInt(this.stats.numMapped);
        out.writeInt(this.stats.numUnmapped);
        out.writeInt(this.stats.numPaired);
        out.writeInt(this.stats.numMappedFirst);
        out.writeInt(this.stats.numMappedSecond);
        out.writeInt(this.stats.NM);
        out.writeInt(this.stats.numHardC);
        out.writeInt(this.stats.numSoftC);
        out.writeInt(this.stats.numIn);
        out.writeInt(this.stats.numDel);
        out.writeInt(this.stats.numPad);
        out.writeInt(this.stats.numSkip);
        out.writeInt(this.stats.accMappingQuality);
        out.writeInt(this.stats.mappingQualityMap.size());
        Iterator iterator = this.stats.mappingQualityMap.keySet().iterator();
        while (iterator.hasNext()) {
            key = (Integer)iterator.next();
            out.writeInt(key);
            out.writeInt((Integer)this.stats.mappingQualityMap.get(key));
        }
        out.writeInt(this.stats.accInsert);
        out.writeInt(this.stats.insertMap.size());
        iterator = this.stats.insertMap.keySet().iterator();
        while (iterator.hasNext()) {
            key = (Integer)iterator.next();
            out.writeInt(key);
            out.writeInt((Integer)this.stats.insertMap.get(key));
        }
        ReadStatsWritable aux = new ReadStatsWritable(this.stats.seqStats);
        aux.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        int i;
        this.stats = new AlignmentStats();
        this.stats.numMapped = in.readInt();
        this.stats.numUnmapped = in.readInt();
        this.stats.numPaired = in.readInt();
        this.stats.numMappedFirst = in.readInt();
        this.stats.numMappedSecond = in.readInt();
        this.stats.NM = in.readInt();
        this.stats.numHardC = in.readInt();
        this.stats.numSoftC = in.readInt();
        this.stats.numIn = in.readInt();
        this.stats.numDel = in.readInt();
        this.stats.numPad = in.readInt();
        this.stats.numSkip = in.readInt();
        this.stats.accMappingQuality = in.readInt();
        int size = in.readInt();
        this.stats.mappingQualityMap = new HashMap(size);
        for (i = 0; i < size; ++i) {
            this.stats.mappingQualityMap.put(in.readInt(), in.readInt());
        }
        this.stats.accInsert = in.readInt();
        size = in.readInt();
        this.stats.insertMap = new HashMap(size);
        for (i = 0; i < size; ++i) {
            this.stats.insertMap.put(in.readInt(), in.readInt());
        }
        ReadStatsWritable aux = new ReadStatsWritable();
        aux.readFields(in);
        this.setSeqStats(aux.getStats());
    }
}

