/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.tools.io.parquet;

import org.apache.avro.Schema;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.parquet.avro.AvroParquetOutputFormat;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.opencb.hpg.bigdata.tools.io.parquet.ParquetMapper;
import org.opencb.hpg.bigdata.tools.utils.CompressionUtils;

public class ParquetMR {
    private final Schema schema;

    public ParquetMR(Schema schema) {
        this.schema = schema;
    }

    public int run(String input, String output, String codecName) throws Exception {
        Configuration conf = new Configuration();
        Job job = Job.getInstance((Configuration)conf, (String)"ParquetMR");
        job.setJarByClass(this.getClass());
        FileInputFormat.addInputPath((Job)job, (Path)new Path(input));
        job.setInputFormatClass(AvroKeyInputFormat.class);
        AvroJob.setInputKeySchema((Job)job, (Schema)this.schema);
        job.setOutputFormatClass(AvroParquetOutputFormat.class);
        AvroParquetOutputFormat.setOutputPath((Job)job, (Path)new Path(output));
        AvroParquetOutputFormat.setSchema((Job)job, (Schema)this.schema);
        AvroParquetOutputFormat.setCompression((Job)job, (CompressionCodecName)CompressionUtils.getParquetCodec(codecName));
        AvroParquetOutputFormat.setCompressOutput((Job)job, (boolean)true);
        AvroParquetOutputFormat.setBlockSize((Job)job, (int)524288000);
        job.setMapperClass(ParquetMapper.class);
        job.setNumReduceTasks(0);
        return job.waitForCompletion(true) ? 0 : 1;
    }
}

