/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.tools.converters.mr.hbase;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.ga4gh.models.Call;
import org.ga4gh.models.Variant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenomeVariantConverter
extends Mapper<AvroKey<Variant>, NullWritable, String, ByteBuffer> {
    private final Logger log = LoggerFactory.getLogger(GenomeVariantConverter.class);
    private static final String ILLUMINA_GVCF_BLOCK_END = "END";
    public static final Integer BUCKET_SIZE = 100;
    private DatumWriter<Variant> variantDatumWriter = new SpecificDatumWriter(Variant.class);

    protected void map(AvroKey<Variant> key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
        Variant variant = (Variant)key.datum();
        List<Variant> varList = this.process(context, variant);
        Map<String, List<Variant>> grouped = this.groupVariants(varList);
        Map<String, ByteBuffer> packageVariants = this.packageVariants(grouped);
        this.submit(context, packageVariants);
    }

    private void submit(Mapper.Context context, Map<String, ByteBuffer> packageVariants) throws IOException, InterruptedException {
        for (Map.Entry<String, ByteBuffer> entry : packageVariants.entrySet()) {
            context.write((Object)entry.getKey(), (Object)entry.getValue());
        }
    }

    private ByteBuffer convert(List<Variant> list) {
        StringBuilder sb = new StringBuilder();
        for (Variant variant : list) {
            sb.append(variant);
        }
        ByteBuffer wrap = ByteBuffer.wrap(sb.toString().getBytes());
        return wrap;
    }

    private Map<String, ByteBuffer> packageVariants(Map<String, List<Variant>> groups) {
        HashMap<String, ByteBuffer> pack = new HashMap<String, ByteBuffer>();
        groups.forEach((k, v) -> pack.put((String)k, this.convert((List<Variant>)v)));
        return pack;
    }

    private String generateBlockId(Variant var) {
        long start = var.getStart() / (long)BUCKET_SIZE.intValue();
        StringBuilder sb = new StringBuilder(var.getReferenceName());
        sb.append("_");
        sb.append(start);
        return sb.toString();
    }

    private Map<String, List<Variant>> groupVariants(List<Variant> varList) {
        Map<String, List<Variant>> grouped = varList.stream().collect(Collectors.groupingBy(var -> this.generateBlockId((Variant)var)));
        return grouped;
    }

    public List<Variant> process(Mapper.Context context, Variant variant) {
        if (this.isReference(variant)) {
            List<Variant> varList = this.expandReferenceRegion(context, variant);
            return varList;
        }
        List<Variant> varList = this.expandAltRegion(context, variant);
        return varList;
    }

    private List<Variant> expandAltRegion(Mapper.Context context, Variant variant) {
        ArrayList<Variant> varList = new ArrayList<Variant>(1);
        String refBases = variant.getReferenceBases();
        List altBasesList = variant.getAlternateBases();
        int altCnt = altBasesList.size();
        List calls = this.nonull(variant.getCalls());
        if (altCnt > 1) {
            context.getCounter("VCF", "biallelic_COUNT").increment(1L);
        }
        if (calls.isEmpty()) {
            context.getCounter("VCF", "NO_CALL_COUNT").increment(1L);
        }
        for (int altIdx = 0; altIdx < altCnt; ++altIdx) {
            String altBases = (String)altBasesList.get(altIdx);
            if (altBases.length() < 50 && refBases.length() < 50) continue;
            context.getCounter("VCF", "SV_LIMIT_REACHED_COUNT").increment(1L);
        }
        varList.add(variant);
        return varList;
    }

    private boolean isReference(Variant variant) {
        return null == variant.getAlternateBases() || variant.getAlternateBases().isEmpty();
    }

    protected List<Variant> expandReferenceRegion(Mapper.Context context, Variant variant) {
        Long start = variant.getStart();
        Long endPos = start + 1L;
        List<Call> calls = this.nonull(variant.getCalls());
        boolean nocall = calls.isEmpty();
        context.getCounter("VCF", "REG_EXPAND" + (nocall ? "_NOCALL" : "")).increment(1L);
        HashMap<String, List<String>> info = new HashMap<String, List<String>>(variant.getInfo());
        List endLst = this.nonull((List)info.remove(ILLUMINA_GVCF_BLOCK_END));
        if (endLst.isEmpty()) {
            context.getCounter("VCF", "REF_END_EMPTY" + (nocall ? "_NOCALL" : "")).increment(1L);
        } else {
            String endStr = ((String)endLst.get(0)).toString();
            endPos = Long.valueOf(endStr);
        }
        String counterName = "REG_EXPAND_CNT" + (nocall ? "_NOCALL" : "");
        context.getCounter("VCF", counterName).increment(endPos - start);
        List<Variant> expVarList = this.expand(variant, start, endPos, info, calls);
        return expVarList;
    }

    protected List<Variant> expand(Variant variant, Long start, Long end, Map<String, List<String>> info, List<Call> calls) {
        ArrayList<Variant> varList = new ArrayList<Variant>(Long.valueOf(end - start).intValue());
        List names = variant.getNames();
        String setId = variant.getVariantSetId();
        Long created = variant.getCreated();
        String id = variant.getId();
        Long updated = variant.getUpdated();
        String refName = variant.getReferenceName();
        String refBases = variant.getReferenceBases();
        List alternateBases = variant.getAlternateBases();
        Long pos = start;
        while (pos < end) {
            Variant var = new Variant();
            var.setStart(pos);
            var.setEnd(Long.valueOf(pos + 1L));
            var.setInfo(info);
            var.setCalls(calls);
            var.setNames(names);
            var.setVariantSetId(setId);
            var.setCreated(created);
            var.setId(id);
            var.setUpdated(updated);
            var.setReferenceName(refName);
            var.setReferenceBases(refBases);
            var.setAlternateBases(alternateBases);
            varList.add(var);
            pos = pos + 1L;
        }
        return varList;
    }

    private <T> List<T> nonull(List<T> list) {
        if (null == list) {
            return Collections.emptyList();
        }
        return list;
    }
}

