/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.tools.alignment.stats;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.util.LineReader;
import htsjdk.samtools.util.StringLineReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.ga4gh.models.LinearAlignment;
import org.ga4gh.models.ReadAlignment;
import org.opencb.biodata.tools.alignment.filtering.RegionFilter;
import org.opencb.biodata.tools.alignment.tasks.RegionDepth;
import org.opencb.biodata.tools.alignment.tasks.RegionDepthCalculator;
import org.opencb.hpg.bigdata.tools.alignment.RegionDepthWritable;
import org.opencb.hpg.bigdata.tools.utils.ChunkKey;

public class ReadAlignmentDepthMR {
    public static final String OUTPUT_SUMMARY_JSON = "summary.depth.json";
    public static final String REGIONS_PARAM = "regions";
    public static final String MIN_MAPQ_PARAM = "min_mapq";

    public static int run(String input, String output, String regions, int minMapQ) throws Exception {
        return ReadAlignmentDepthMR.run(input, output, regions, minMapQ, new Configuration());
    }

    public static int run(String input, String output, String regions, int minMapQ, Configuration conf) throws Exception {
        SAMSequenceRecord sr;
        byte[] data = null;
        Path headerPath = new Path(input + ".header");
        FileSystem hdfs = FileSystem.get((Configuration)conf);
        FSDataInputStream dis = hdfs.open(headerPath);
        FileStatus status = hdfs.getFileStatus(headerPath);
        data = new byte[(int)status.getLen()];
        dis.read(data, 0, (int)status.getLen());
        dis.close();
        String textHeader = new String(data);
        StringLineReader lineReader = new StringLineReader(textHeader);
        SAMFileHeader header = new SAMTextHeaderCodec().decode((LineReader)lineReader, textHeader);
        int i = 0;
        while ((sr = header.getSequence(i++)) != null) {
            conf.setInt(sr.getSequenceName(), sr.getSequenceLength());
        }
        conf.set(OUTPUT_SUMMARY_JSON, output + "summary.json");
        if (regions != null) {
            conf.set(REGIONS_PARAM, regions);
        }
        conf.set(MIN_MAPQ_PARAM, "" + minMapQ);
        Job job = Job.getInstance((Configuration)conf, (String)"ReadAlignmentDepthMR");
        job.setJarByClass(ReadAlignmentDepthMR.class);
        AvroJob.setInputKeySchema((Job)job, (Schema)ReadAlignment.SCHEMA$);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(input)});
        job.setInputFormatClass(AvroKeyInputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(output));
        job.setOutputKeyClass(RegionDepthWritable.class);
        job.setOutputValueClass(NullWritable.class);
        job.setMapperClass(ReadAlignmentDepthMapper.class);
        job.setMapOutputKeyClass(ChunkKey.class);
        job.setMapOutputValueClass(RegionDepthWritable.class);
        job.setCombinerClass(ReadAlignmentDepthCombiner.class);
        job.setReducerClass(ReadAlignmentDepthReducer.class);
        job.setNumReduceTasks(1);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static class ReadAlignmentDepthReducer
    extends Reducer<ChunkKey, RegionDepthWritable, Text, NullWritable> {
        private RegionFilter regionFilter = null;
        private HashMap<String, Long> chromAccDepth = null;

        public void setup(Reducer.Context context) throws IOException, InterruptedException {
            String regs = context.getConfiguration().get(ReadAlignmentDepthMR.REGIONS_PARAM);
            if (regs != null) {
                System.err.println(">>>>>>> reducer, regs = " + regs);
                this.regionFilter = new RegionFilter(regs);
            }
            this.chromAccDepth = new HashMap();
        }

        public void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            double accLen = 0.0;
            double accDep = 0.0;
            FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
            Path outPath = new Path(context.getConfiguration().get(ReadAlignmentDepthMR.OUTPUT_SUMMARY_JSON));
            FSDataOutputStream out = fs.create(outPath);
            out.writeChars("{ \"chroms\": [");
            int size = this.chromAccDepth.size();
            int i = 0;
            for (String name : this.chromAccDepth.keySet()) {
                out.writeChars("{\"name\": \"" + name + "\", \"length\": " + context.getConfiguration().get(name) + ", \"acc\": " + this.chromAccDepth.get(name) + ", \"depth\": " + 1.0f * (float)this.chromAccDepth.get(name).longValue() / (float)Integer.parseInt(context.getConfiguration().get(name)) + "}");
                if (++i < size) {
                    out.writeChars(", ");
                }
                accLen += (double)Integer.parseInt(context.getConfiguration().get(name));
                accDep += (double)this.chromAccDepth.get(name).longValue();
            }
            out.writeChars("], \"depth\": " + accDep / accLen);
            out.writeChars("}");
            out.close();
        }

        public void reduce(ChunkKey key, Iterable<RegionDepthWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            if (context.getConfiguration().get(key.getName()) == null) {
                System.out.println("Skip unknown key (name, chunk) = (" + key.getName() + ", " + key.getChunk() + ")");
                return;
            }
            RegionDepth regionDepth = new RegionDepth(key.getName(), key.getChunk() * 4000, key.getChunk().intValue(), 4000);
            RegionDepthCalculator calculator = new RegionDepthCalculator();
            for (RegionDepthWritable value : values) {
                calculator.updateChunk(value.getRegionDepth(), (long)key.getChunk().intValue(), regionDepth);
            }
            long acc = 0L;
            for (int i = 0; i < 4000; ++i) {
                acc += (long)regionDepth.array[i];
            }
            this.chromAccDepth.put(key.getName(), this.chromAccDepth.get(key.getName()) == null ? acc : acc + this.chromAccDepth.get(key.getName()));
            if (this.regionFilter == null) {
                context.write((Object)new Text(regionDepth.toFormat()), (Object)NullWritable.get());
            } else {
                context.write((Object)new Text(regionDepth.toFormat(this.regionFilter)), (Object)NullWritable.get());
            }
        }
    }

    public static class ReadAlignmentDepthCombiner
    extends Reducer<ChunkKey, RegionDepthWritable, ChunkKey, RegionDepthWritable> {
        public void reduce(ChunkKey key, Iterable<RegionDepthWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            RegionDepth regionDepth = new RegionDepth(key.getName(), key.getChunk() * 4000, key.getChunk().intValue(), 4000);
            RegionDepthCalculator calculator = new RegionDepthCalculator();
            for (RegionDepthWritable value : values) {
                calculator.updateChunk(value.getRegionDepth(), (long)key.getChunk().intValue(), regionDepth);
            }
            context.write((Object)key, (Object)new RegionDepthWritable(regionDepth));
        }
    }

    public static class ReadAlignmentDepthMapper
    extends Mapper<AvroKey<ReadAlignment>, NullWritable, ChunkKey, RegionDepthWritable> {
        private RegionFilter regionFilter = null;
        private int minMapQ = 0;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            String regs = context.getConfiguration().get(ReadAlignmentDepthMR.REGIONS_PARAM);
            if (regs != null) {
                System.err.println(">>>>>>> mapper, regs = " + regs);
                this.regionFilter = new RegionFilter(regs);
            }
            this.minMapQ = context.getConfiguration().getInt(ReadAlignmentDepthMR.MIN_MAPQ_PARAM, 0);
        }

        public void map(AvroKey<ReadAlignment> key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
            ReadAlignment ra = (ReadAlignment)key.datum();
            LinearAlignment linearAlignment = ra.getAlignment();
            if (linearAlignment == null) {
                return;
            }
            RegionDepthCalculator calculator = new RegionDepthCalculator();
            String chrom = linearAlignment.getPosition().getReferenceName().toString();
            int start = linearAlignment.getPosition().getPosition().intValue();
            int end = start + calculator.computeSizeByCigar(linearAlignment.getCigar()) - 1;
            if (this.minMapQ < linearAlignment.getMappingQuality() && (this.regionFilter == null || this.regionFilter.apply(chrom, start, end))) {
                List regions = calculator.computeAsList(ra);
                for (RegionDepth region : regions) {
                    ChunkKey newKey = new ChunkKey(region.chrom, region.chunk);
                    RegionDepthWritable newValue = new RegionDepthWritable(region);
                    context.write((Object)newKey, (Object)newValue);
                }
            }
        }
    }
}

