/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.tools.alignment;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.opencb.biodata.tools.alignment.tasks.RegionDepth;

public class RegionDepthWritable
implements Writable {
    private RegionDepth regionDepth;

    public RegionDepthWritable() {
    }

    public RegionDepthWritable(RegionDepth regionDepth) {
        this.setRegionDepth(regionDepth);
    }

    public RegionDepth getRegionDepth() {
        return this.regionDepth;
    }

    public void setRegionDepth(RegionDepth regionDepth) {
        this.regionDepth = regionDepth;
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.regionDepth.chrom);
        out.writeInt(this.regionDepth.position);
        out.writeInt(this.regionDepth.chunk);
        out.writeInt(this.regionDepth.size);
        for (int i = 0; i < this.regionDepth.size; ++i) {
            out.writeShort(this.regionDepth.array[i]);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.regionDepth = new RegionDepth();
        this.regionDepth.chrom = in.readUTF();
        this.regionDepth.position = in.readInt();
        this.regionDepth.chunk = in.readInt();
        this.regionDepth.size = in.readInt();
        this.regionDepth.array = this.regionDepth.size > 0 ? new short[this.regionDepth.size] : null;
        for (int i = 0; i < this.regionDepth.size; ++i) {
            this.regionDepth.array[i] = in.readShort();
        }
    }
}

