/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.tools.alignment;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyOutputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.ga4gh.models.ReadAlignment;
import org.opencb.hpg.bigdata.core.converters.SAMRecord2ReadAlignmentConverter;
import org.opencb.hpg.bigdata.tools.utils.ChunkKey;
import org.opencb.hpg.bigdata.tools.utils.CompressionUtils;
import org.seqdoop.hadoop_bam.AnySAMInputFormat;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.util.WrapSeekable;

public class Bam2AvroMR {
    public static final String ADJUST_QUALITY = "adjustQuality";

    public static int run(String input, String output, String codecName, boolean adjustQuality) throws Exception {
        return Bam2AvroMR.run(input, output, codecName, adjustQuality, new Configuration());
    }

    public static int run(String input, String output, String codecName, boolean adjQuality, Configuration conf) throws Exception {
        SAMSequenceRecord sr;
        Path p = new Path(input);
        WrapSeekable seekableStream = WrapSeekable.openPath((Configuration)conf, (Path)p);
        SamReader reader = SamReaderFactory.make().open(SamInputResource.of((SeekableStream)seekableStream));
        SAMFileHeader header = reader.getFileHeader();
        int i = 0;
        while ((sr = header.getSequence(i)) != null) {
            conf.set("" + i, sr.getSequenceName());
            ++i;
        }
        Job job = Job.getInstance((Configuration)conf, (String)"Bam2AvroMR");
        job.setJarByClass(Bam2AvroMR.class);
        job.getConfiguration().set("mapreduce.job.user.classpath.first", "true");
        job.getConfiguration().set(ADJUST_QUALITY, Boolean.toString(adjQuality));
        AvroJob.setOutputKeySchema((Job)job, (Schema)ReadAlignment.getClassSchema());
        job.setOutputValueClass(NullWritable.class);
        AvroJob.setMapOutputValueSchema((Job)job, (Schema)ReadAlignment.getClassSchema());
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(input)});
        job.setInputFormatClass(AnySAMInputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(output));
        if (codecName != null) {
            FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
            FileOutputFormat.setOutputCompressorClass((Job)job, CompressionUtils.getHadoopCodec(codecName));
        }
        job.setOutputFormatClass(AvroKeyOutputFormat.class);
        job.setMapOutputKeyClass(AvroKey.class);
        job.setMapOutputValueClass(Void.class);
        job.setMapperClass(Bam2GaMapper.class);
        job.setNumReduceTasks(0);
        job.waitForCompletion(true);
        Path headerPath = new Path(output + "/part-m-00000.avro.header");
        FileSystem fs = FileSystem.get((Configuration)conf);
        BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(headerPath, true)));
        br.write(header.getTextHeader());
        br.close();
        return 0;
    }

    public static class Bam2GaReducer
    extends Reducer<ChunkKey, AvroValue<ReadAlignment>, AvroKey<ReadAlignment>, NullWritable> {
        public void reduce(ChunkKey key, Iterable<AvroValue<ReadAlignment>> values, Reducer.Context context) throws IOException, InterruptedException {
            for (AvroValue<ReadAlignment> value : values) {
                context.write((Object)new AvroKey(value.datum()), (Object)NullWritable.get());
            }
        }
    }

    public static class Bam2GaMapper
    extends Mapper<LongWritable, SAMRecordWritable, AvroKey<ReadAlignment>, NullWritable> {
        private SAMRecord2ReadAlignmentConverter samRecord2ReadAlignmentConverter;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            boolean adjustQuality = context.getConfiguration().getBoolean(Bam2AvroMR.ADJUST_QUALITY, false);
            this.samRecord2ReadAlignmentConverter = new SAMRecord2ReadAlignmentConverter(adjustQuality);
        }

        public void map(LongWritable key, SAMRecordWritable value, Mapper.Context context) throws IOException, InterruptedException {
            SAMRecord sam = value.get();
            if (sam.getReadUnmappedFlag()) {
                System.out.println("Empty block");
            } else {
                SAMRecord2ReadAlignmentConverter converter = this.samRecord2ReadAlignmentConverter;
                ReadAlignment readAlignment = converter.forward(sam);
                AvroKey newKey = new AvroKey((Object)readAlignment);
                context.write((Object)newKey, (Object)NullWritable.get());
            }
        }
    }
}

