/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.app.rest.ws;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opencb.commons.datastore.core.Query;
import org.opencb.hpg.bigdata.core.lib.VariantParseQuery;

@Path(value="/{version}/variant")
@Produces(value={"application/json"})
@Api(value="Cohorts", position=9, description="Methods for working with 'cohorts' endpoint")
public class VariantWSServer {
    public VariantWSServer(@Context UriInfo uriInfo, @Context HttpServletRequest httpServletRequest) throws IOException {
    }

    @GET
    @Path(value="/sql")
    @ApiOperation(value="Create a cohort", position=1, notes="", response=String.class)
    public Response getSqlQuery(@ApiParam(value="table", required=true) @QueryParam(value="table") String table, @ApiParam(value="id") @QueryParam(value="id") String id, @ApiParam(value="ancestralAllele") @QueryParam(value="ancestralAllele") String ancestralAllele, @ApiParam(value="displayConsequenceType") @QueryParam(value="displayConsequenceType") String displayConsequenceType, @ApiParam(value="xrefs") @QueryParam(value="xrefs") String xrefs, @ApiParam(value="hgvs") @QueryParam(value="hgvs") String hgvs, @ApiParam(value="consequenceTypes") @QueryParam(value="consequenceTypes") String consequenceTypes, @ApiParam(value="consequenceTypes.sequenceOntologyTerms.accession") @QueryParam(value="consequenceTypes.sequenceOntologyTerms.accession") String consequenceSoAccession, @ApiParam(value="consequenceTypes.sequenceOntologyTerms.name") @QueryParam(value="consequenceTypes.sequenceOntologyTerms.name") String consequenceSoName, @ApiParam(value="populationFrequencies") @QueryParam(value="populationFrequencies") String populationFrequencies, @ApiParam(value="conservation") @QueryParam(value="conservation") String conservation, @ApiParam(value="variantTraitAssociation") @QueryParam(value="variantTraitAssociation") String variantTraitAssociation) {
        try {
            Query query = new Query();
            query.putIfNotEmpty("id", id);
            query.putIfNotEmpty("ancestralAllele", ancestralAllele);
            query.putIfNotEmpty("displayConsequenceType", displayConsequenceType);
            query.putIfNotEmpty("xrefs", xrefs);
            query.putIfNotEmpty("hgvs", hgvs);
            query.putIfNotEmpty("annotation.consequenceTypes", consequenceTypes);
            query.putIfNotEmpty("annotation.populationFrequencies", populationFrequencies);
            query.putIfNotEmpty("annotation.consequenceTypes.sequenceOntologyTerms.accession", consequenceSoAccession);
            query.putIfNotEmpty("annotation.consequenceTypes.sequenceOntologyTerms.name", consequenceSoName);
            query.putIfNotEmpty("annotation.conservation", conservation);
            query.putIfNotEmpty("annotation.variantTraitAssociation", variantTraitAssociation);
            VariantParseQuery variantParseQuery = new VariantParseQuery();
            String sql = variantParseQuery.parse(query, null, table);
            return Response.ok((Object)sql).build();
        }
        catch (Exception e) {
            return Response.ok((Object)e.toString()).build();
        }
    }
}

