/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.app.rest.ws;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opencb.commons.datastore.core.QueryResponse;
import org.opencb.hpg.bigdata.app.rest.RestServer;

@Path(value="/admin")
public class AdminRestWebService {
    @DefaultValue(value="v1")
    @QueryParam(value="version")
    protected String version;
    private static RestServer server;

    public AdminRestWebService(@PathParam(value="version") String version, @Context UriInfo uriInfo, @Context HttpServletRequest httpServletRequest, @Context ServletContext context) throws IOException {
        System.out.println("Build AdminWSServer");
    }

    @GET
    @Path(value="/stop")
    @Produces(value={"text/plain"})
    public Response stop() {
        try {
            server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.createOkResponse("bye!");
    }

    public static RestServer getServer() {
        return server;
    }

    public static void setServer(RestServer server) {
        AdminRestWebService.server = server;
    }

    protected Response createOkResponse(Object obj) {
        ArrayList<Object> coll;
        QueryResponse queryResponse = new QueryResponse();
        queryResponse.setTime(new Long(0L).intValue());
        queryResponse.setApiVersion(this.version);
        if (obj instanceof List) {
            coll = (ArrayList<Object>)obj;
        } else {
            coll = new ArrayList<Object>();
            coll.add(obj);
        }
        queryResponse.setResponse(coll);
        try {
            ObjectMapper jsonObjectMapper = new ObjectMapper();
            return this.buildResponse(Response.ok((Object)jsonObjectMapper.writer().writeValueAsString((Object)queryResponse), (MediaType)MediaType.APPLICATION_JSON_TYPE));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Response buildResponse(Response.ResponseBuilder responseBuilder) {
        return responseBuilder.header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Headers", (Object)"x-requested-with, content-type").build();
    }
}

