/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.app.rest;

import javax.servlet.Servlet;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.opencb.hpg.bigdata.app.rest.ws.AdminRestWebService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServer {
    private static Server server;
    private int port;
    private boolean exit;
    private static Logger logger;

    public RestServer() {
        this(1042);
    }

    public RestServer(int port) {
        this.port = port;
        this.init();
    }

    private void init() {
        logger = LoggerFactory.getLogger(this.getClass());
    }

    public void start() throws Exception {
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.packages(true, new String[]{"org.opencb.hpg.bigdata.app.rest.ws"});
        ServletContainer sc = new ServletContainer(resourceConfig);
        ServletHolder sh = new ServletHolder("bigdata", (Servlet)sc);
        server = new Server(this.port);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, null, 1);
        context.addServlet(sh, "/bigdata/webservices/rest/*");
        server.start();
        logger.info("REST server started, listening on {}", (Object)this.port);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    if (server.isRunning()) {
                        RestServer.this.stopJettyServer();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        new Thread(() -> {
            try {
                while (true) {
                    if (this.exit) {
                        this.stopJettyServer();
                        break;
                    }
                    Thread.sleep(500L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
        AdminRestWebService.setServer(this);
    }

    public void stop() throws Exception {
        this.exit = true;
    }

    public void blockUntilShutdown() throws InterruptedException {
        if (server != null) {
            server.join();
        }
    }

    private void stopJettyServer() throws Exception {
        logger.info("Shutting down Jetty server");
        server.stop();
        logger.info("REST server shut down");
    }

    static {
        logger = LoggerFactory.getLogger((String)"org.opencb.hpg.bigdata.app.rest.RestServer");
    }
}

