/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.app.cli.local;

import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SparkSession;
import org.opencb.biodata.formats.variant.vcf4.FullVcfCodec;
import org.opencb.biodata.models.core.Region;
import org.opencb.biodata.models.variant.Variant;
import org.opencb.biodata.models.variant.avro.VariantAvro;
import org.opencb.biodata.tools.variant.converters.Converter;
import org.opencb.biodata.tools.variant.converters.avro.VariantContextToVariantConverter;
import org.opencb.commons.io.DataReader;
import org.opencb.commons.io.DataWriter;
import org.opencb.commons.run.ParallelTaskRunner;
import org.opencb.commons.utils.FileUtils;
import org.opencb.hpg.bigdata.app.cli.CommandExecutor;
import org.opencb.hpg.bigdata.app.cli.local.LocalCliOptionsParser;
import org.opencb.hpg.bigdata.core.avro.VariantAvroAnnotator;
import org.opencb.hpg.bigdata.core.avro.VariantAvroSerializer;
import org.opencb.hpg.bigdata.core.converters.variation.VariantAvroEncoderTask;
import org.opencb.hpg.bigdata.core.converters.variation.VariantContext2VariantConverter;
import org.opencb.hpg.bigdata.core.io.VcfBlockIterator;
import org.opencb.hpg.bigdata.core.io.avro.AvroFileWriter;
import org.opencb.hpg.bigdata.core.lib.SparkConfCreator;
import org.opencb.hpg.bigdata.core.lib.VariantDataset;
import org.opencb.hpg.bigdata.core.parquet.VariantParquetConverter;

public class VariantCommandExecutor
extends CommandExecutor {
    private LocalCliOptionsParser.VariantCommandOptions variantCommandOptions;

    public VariantCommandExecutor(LocalCliOptionsParser.VariantCommandOptions variantCommandOptions) {
        this.variantCommandOptions = variantCommandOptions;
    }

    @Override
    public void execute() throws Exception {
        String subCommandString;
        switch (subCommandString = this.variantCommandOptions.getParsedSubCommand()) {
            case "convert": {
                this.init(this.variantCommandOptions.convertVariantCommandOptions.commonOptions.logLevel, this.variantCommandOptions.convertVariantCommandOptions.commonOptions.verbose, this.variantCommandOptions.convertVariantCommandOptions.commonOptions.conf);
                this.convert();
                break;
            }
            case "annotate": {
                this.init(this.variantCommandOptions.convertVariantCommandOptions.commonOptions.logLevel, this.variantCommandOptions.convertVariantCommandOptions.commonOptions.verbose, this.variantCommandOptions.convertVariantCommandOptions.commonOptions.conf);
                this.annotate();
            }
            case "query": {
                this.init(this.variantCommandOptions.queryVariantCommandOptions.commonOptions.logLevel, this.variantCommandOptions.queryVariantCommandOptions.commonOptions.verbose, this.variantCommandOptions.queryVariantCommandOptions.commonOptions.conf);
                this.query();
                break;
            }
        }
    }

    private void convert() throws Exception {
        Path inputPath = Paths.get(this.variantCommandOptions.convertVariantCommandOptions.input, new String[0]);
        FileUtils.checkFile((Path)inputPath);
        String to = this.variantCommandOptions.convertVariantCommandOptions.to;
        if (!(to.equals("avro") || to.equals("parquet") || to.equals("json"))) {
            throw new IllegalArgumentException("Unknown serialization format: " + to + ". Valid values: avro, parquet and json");
        }
        String output = this.variantCommandOptions.convertVariantCommandOptions.output;
        boolean stdOutput = this.variantCommandOptions.convertVariantCommandOptions.stdOutput;
        if (stdOutput) {
            output = "STDOUT";
        } else {
            if (output != null && !output.isEmpty()) {
                Path parent = Paths.get(output, new String[0]).toAbsolutePath().getParent();
                if (parent != null) {
                    FileUtils.checkDirectory((Path)parent, (boolean)true);
                }
            } else {
                output = inputPath.toString() + "." + to;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(output);
        }
        String compression = this.variantCommandOptions.convertVariantCommandOptions.compression;
        List regions = null;
        if (StringUtils.isNotEmpty((CharSequence)this.variantCommandOptions.convertVariantCommandOptions.regions)) {
            regions = Region.parseRegions((String)this.variantCommandOptions.convertVariantCommandOptions.regions);
        }
        switch (this.variantCommandOptions.convertVariantCommandOptions.to) {
            case "avro": {
                VariantAvroSerializer avroSerializer = new VariantAvroSerializer(compression);
                if (regions != null) {
                    regions.forEach(arg_0 -> ((VariantAvroSerializer)avroSerializer).addRegionFilter(arg_0));
                }
                avroSerializer.toAvro(inputPath.toString(), output);
                break;
            }
            case "parquet": {
                FileInputStream is = new FileInputStream(this.variantCommandOptions.convertVariantCommandOptions.input);
                VariantParquetConverter parquetConverter = new VariantParquetConverter();
                parquetConverter.toParquet((InputStream)is, this.variantCommandOptions.convertVariantCommandOptions.output + "2");
                break;
            }
            default: {
                System.out.println("No valid format: " + this.variantCommandOptions.convertVariantCommandOptions.to);
            }
        }
    }

    private void convertToJson(Path inputPath, String dataModel, OutputStream outputStream) throws IOException {
        VCFFileReader reader = new VCFFileReader(inputPath.toFile(), false);
        switch (dataModel.toLowerCase()) {
            case "opencb": {
                VariantContextToVariantConverter variantContextToVariantConverter = new VariantContextToVariantConverter("", "", Collections.emptyList());
                for (VariantContext variantContext : reader) {
                    Variant variant = variantContextToVariantConverter.convert(variantContext);
                    outputStream.write(variant.toJson().getBytes());
                    outputStream.write(10);
                }
                break;
            }
            case "ga4gh": {
                VariantContext2VariantConverter variantContext2VariantConverter = new VariantContext2VariantConverter();
                for (VariantContext variantContext : reader) {
                    org.ga4gh.models.Variant variant = variantContext2VariantConverter.forward(variantContext);
                    outputStream.write(variant.toString().getBytes());
                    outputStream.write(10);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown dataModel \"" + dataModel + "\"");
            }
        }
        reader.close();
    }

    private void convertToAvro(Path inputPath, String compression, String dataModel, OutputStream outputStream) throws Exception {
        ParallelTaskRunner runner;
        VcfBlockIterator iterator = StringUtils.equals((CharSequence)"-", (CharSequence)inputPath.toAbsolutePath().toString()) ? new VcfBlockIterator((InputStream)new BufferedInputStream(System.in), new FullVcfCodec()) : new VcfBlockIterator(inputPath.toFile(), new FullVcfCodec());
        DataReader vcfDataReader = iterator.toCharBufferDataReader();
        ArrayList sampleNamesInOrder = iterator.getHeader().getSampleNamesInOrder();
        int numTasks = Math.max(this.variantCommandOptions.convertVariantCommandOptions.numThreads, 1);
        int batchSize = 0x100000;
        int capacity = numTasks + 1;
        ParallelTaskRunner.Config config = new ParallelTaskRunner.Config(numTasks, batchSize, capacity, false);
        switch (dataModel.toLowerCase()) {
            case "opencb": {
                Schema classSchema = VariantAvro.getClassSchema();
                VariantContextToVariantConverter converter = new VariantContextToVariantConverter("", "", (List)sampleNamesInOrder);
                AvroFileWriter avroFileWriter = new AvroFileWriter(classSchema, compression, outputStream);
                runner = new ParallelTaskRunner(vcfDataReader, () -> new VariantAvroEncoderTask(iterator.getHeader(), iterator.getVersion(), variantContext -> converter.convert(variantContext).getImpl(), classSchema), (DataWriter)avroFileWriter, config);
                break;
            }
            case "ga4gh": {
                Schema classSchema = org.ga4gh.models.Variant.getClassSchema();
                VariantContext2VariantConverter converter = new VariantContext2VariantConverter();
                converter.setVariantSetId("");
                AvroFileWriter avroFileWriter = new AvroFileWriter(classSchema, compression, outputStream);
                runner = new ParallelTaskRunner(vcfDataReader, () -> new VariantAvroEncoderTask(iterator.getHeader(), iterator.getVersion(), (Converter)converter, classSchema), (DataWriter)avroFileWriter, config);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown dataModel \"" + dataModel + "\"");
            }
        }
        long start = System.currentTimeMillis();
        runner.run();
        this.logger.debug("Time " + (double)(System.currentTimeMillis() - start) / 1000.0 + "s");
    }

    public void query() throws Exception {
        String[] accessions;
        String[] stringArray;
        int n;
        String[] names;
        String[] stringArray2;
        int n2;
        String[] ids;
        Object object;
        int n3;
        int n4;
        Path inputPath = Paths.get(this.variantCommandOptions.queryVariantCommandOptions.input, new String[0]);
        FileUtils.checkFile((Path)inputPath);
        SparkConf sparkConf = SparkConfCreator.getConf((String)"variant query", (String)"local", (int)1, (boolean)true, (String)"/home/jtarraga/soft/spark-2.0.0/");
        System.out.println("sparkConf = " + sparkConf.toDebugString());
        SparkSession sparkSession = new SparkSession(new SparkContext(sparkConf));
        VariantDataset vd = new VariantDataset();
        vd.load(this.variantCommandOptions.queryVariantCommandOptions.input, sparkSession);
        vd.createOrReplaceTempView("vcf");
        if (StringUtils.isNotEmpty((CharSequence)this.variantCommandOptions.queryVariantCommandOptions.ids) && (n4 = 0) < (n3 = ((String[])(object = (ids = StringUtils.split((String)this.variantCommandOptions.queryVariantCommandOptions.ids, (String)",")))).length)) {
            String id = object[n4];
            vd.idFilter(id);
            this.logger.warn("Query for multiple IDs, not yet implemented. Currently, it queries for the first ID.");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.variantCommandOptions.queryVariantCommandOptions.types)) {
            String[] types = StringUtils.split((String)this.variantCommandOptions.queryVariantCommandOptions.types, (String)",");
            if (types.length == 1) {
                vd.typeFilter(types[0]);
            } else {
                vd.typeFilter(new ArrayList<String>(Arrays.asList(types)));
            }
        }
        List regions = null;
        if (StringUtils.isNotEmpty((CharSequence)this.variantCommandOptions.queryVariantCommandOptions.regions) && (object = (regions = Region.parseRegions((String)this.variantCommandOptions.queryVariantCommandOptions.regions)).iterator()).hasNext()) {
            Region region = (Region)object.next();
            this.logger.warn("Query for region, not yet implemented.");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.variantCommandOptions.queryVariantCommandOptions.so_names) && (n2 = 0) < (n4 = (stringArray2 = (names = StringUtils.split((String)this.variantCommandOptions.queryVariantCommandOptions.so_names, (String)","))).length)) {
            String name = stringArray2[n2];
            vd.annotationFilter("consequenceTypes.sequenceOntologyTerms.name", name);
            this.logger.warn("Query for multiple SO term names (consequence type), not yet implemented. Currently, it queries for the first SO term name.");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.variantCommandOptions.queryVariantCommandOptions.so_accessions) && (n = 0) < (n4 = (stringArray = (accessions = StringUtils.split((String)this.variantCommandOptions.queryVariantCommandOptions.so_accessions, (String)","))).length)) {
            String accession = stringArray[n];
            vd.annotationFilter("consequenceTypes.sequenceOntologyTerms.accession", accession);
            this.logger.warn("Query for multiple SO term accessions (consequence type), not yet implemented. Currently, it queries for the first SO term accession.");
        }
        vd.update();
        this.logger.warn("The current query implementation saves the resulting dataset in Avro format.");
        vd.write().format("com.databricks.spark.avro").save(this.variantCommandOptions.queryVariantCommandOptions.output);
    }

    public void annotate() throws IOException {
        VariantAvroAnnotator variantAvroAnnotator = new VariantAvroAnnotator();
        Path input = Paths.get(this.variantCommandOptions.annotateVariantCommandOptions.input, new String[0]);
        Path output = Paths.get(this.variantCommandOptions.annotateVariantCommandOptions.ouput, new String[0]);
        variantAvroAnnotator.annotate(input, output);
    }
}

