/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.app.cli.local;

import htsjdk.samtools.fastq.FastqReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.io.DatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.opencb.biodata.models.sequence.Read;
import org.opencb.biodata.tools.alignment.stats.SequenceStats;
import org.opencb.biodata.tools.alignment.stats.SequenceStatsCalculator;
import org.opencb.hpg.bigdata.app.cli.CommandExecutor;
import org.opencb.hpg.bigdata.app.cli.local.LocalCliOptionsParser;
import org.opencb.hpg.bigdata.core.converters.FastqRecord2ReadConverter;
import org.opencb.hpg.bigdata.core.io.avro.AvroWriter;
import org.opencb.hpg.bigdata.core.utils.AvroUtils;

public class SequenceCommandExecutor
extends CommandExecutor {
    private LocalCliOptionsParser.SequenceCommandOptions sequenceCommandOptions;

    public SequenceCommandExecutor(LocalCliOptionsParser.SequenceCommandOptions sequenceCommandOptions) {
        this.sequenceCommandOptions = sequenceCommandOptions;
    }

    @Override
    public void execute() throws IOException {
        String subCommand;
        switch (subCommand = this.sequenceCommandOptions.getParsedSubCommand()) {
            case "convert": {
                this.convert();
                break;
            }
            case "stats": {
                this.stats();
                break;
            }
        }
    }

    private void convert() throws IOException {
        LocalCliOptionsParser.ConvertSequenceCommandOptions convertSequenceCommandOptions = this.sequenceCommandOptions.convertSequenceCommandOptions;
        String input = convertSequenceCommandOptions.input;
        String output = convertSequenceCommandOptions.output;
        String codecName = convertSequenceCommandOptions.compression;
        FastqReader reader = new FastqReader(new File(input));
        FileOutputStream os = new FileOutputStream(output);
        AvroWriter writer = new AvroWriter(Read.getClassSchema(), AvroUtils.getCodec((String)codecName), (OutputStream)os);
        FastqRecord2ReadConverter converter = new FastqRecord2ReadConverter();
        while (reader.hasNext()) {
            writer.write((Object)converter.forward(reader.next()));
        }
        reader.close();
        writer.close();
        ((OutputStream)os).close();
    }

    private void stats() throws IOException {
        LocalCliOptionsParser.StatsSequenceCommandOptions statsSequenceCommandOptions = this.sequenceCommandOptions.statsSequenceCommandOptions;
        String input = statsSequenceCommandOptions.input;
        String output = statsSequenceCommandOptions.output;
        int kvalue = statsSequenceCommandOptions.kmers;
        FileInputStream is = new FileInputStream(input);
        DataFileStream reader = new DataFileStream((InputStream)is, (DatumReader)new SpecificDatumReader(Read.class));
        SequenceStats totalStats = new SequenceStats(kvalue);
        SequenceStatsCalculator calculator = new SequenceStatsCalculator();
        for (Read read : reader) {
            SequenceStats stats = calculator.compute(read, kvalue);
            calculator.update(stats, totalStats);
        }
        reader.close();
        ((InputStream)is).close();
        PrintWriter writer = new PrintWriter(new File(output + "/stats.json"));
        writer.write(totalStats.toJSON());
        writer.close();
    }
}

