/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.app.cli.local;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.util.HashMap;
import java.util.Map;

public class LocalCliOptionsParser {
    private final JCommander jcommander;
    private final GeneralOptions generalOptions = new GeneralOptions();
    private final CommandOptions commandOptions;
    private final CommonCommandOptions commonCommandOptions;
    private AdminCommandOptions adminCommandOptions;
    private SequenceCommandOptions sequenceCommandOptions;
    private AlignmentCommandOptions alignmentCommandOptions;
    private VariantCommandOptions variantCommandOptions;

    public LocalCliOptionsParser() {
        this.jcommander = new JCommander((Object)this.generalOptions);
        this.commandOptions = new CommandOptions();
        this.commonCommandOptions = new CommonCommandOptions();
        this.adminCommandOptions = new AdminCommandOptions();
        this.jcommander.addCommand("admin", (Object)this.adminCommandOptions);
        JCommander adminSubCommands = (JCommander)this.jcommander.getCommands().get("admin");
        adminSubCommands.addCommand("server", (Object)this.adminCommandOptions.serverAdminCommandOptions);
        this.sequenceCommandOptions = new SequenceCommandOptions();
        this.jcommander.addCommand("sequence", (Object)this.sequenceCommandOptions);
        JCommander sequenceSubCommands = (JCommander)this.jcommander.getCommands().get("sequence");
        sequenceSubCommands.addCommand("convert", (Object)this.sequenceCommandOptions.convertSequenceCommandOptions);
        sequenceSubCommands.addCommand("stats", (Object)this.sequenceCommandOptions.statsSequenceCommandOptions);
        this.alignmentCommandOptions = new AlignmentCommandOptions();
        this.jcommander.addCommand("alignment", (Object)this.sequenceCommandOptions);
        JCommander alignmentSubCommands = (JCommander)this.jcommander.getCommands().get("alignment");
        alignmentSubCommands.addCommand("convert", (Object)this.alignmentCommandOptions.convertAlignmentCommandOptions);
        alignmentSubCommands.addCommand("stats", (Object)this.alignmentCommandOptions.statsAlignmentCommandOptions);
        alignmentSubCommands.addCommand("coverage", (Object)this.alignmentCommandOptions.coverageAlignmentCommandOptions);
        alignmentSubCommands.addCommand("query", (Object)this.alignmentCommandOptions.queryAlignmentCommandOptions);
        this.variantCommandOptions = new VariantCommandOptions();
        this.jcommander.addCommand("variant", (Object)this.sequenceCommandOptions);
        JCommander variantSubCommands = (JCommander)this.jcommander.getCommands().get("variant");
        variantSubCommands.addCommand("convert", (Object)this.variantCommandOptions.convertVariantCommandOptions);
        variantSubCommands.addCommand("annotate", (Object)this.variantCommandOptions.annotateVariantCommandOptions);
        variantSubCommands.addCommand("query", (Object)this.variantCommandOptions.queryVariantCommandOptions);
    }

    public void parse(String[] args) throws ParameterException {
        this.jcommander.parse(args);
    }

    public String getCommand() {
        return this.jcommander.getParsedCommand() != null ? this.jcommander.getParsedCommand() : "";
    }

    public String getSubCommand() {
        String parsedCommand = this.jcommander.getParsedCommand();
        if (this.jcommander.getCommands().containsKey(parsedCommand)) {
            String subCommand = ((JCommander)this.jcommander.getCommands().get(parsedCommand)).getParsedCommand();
            return subCommand != null ? subCommand : "";
        }
        return null;
    }

    public void printUsage() {
        if (this.getCommand().isEmpty()) {
            System.err.println("");
            System.err.println("Program:     HPG BigData for HPC (OpenCB)");
            System.err.println("Version:     0.2.0");
            System.err.println("Description: Tools for working with NGS data in a standard HPC cluster");
            System.err.println("");
            System.err.println("Usage:       hpg-bigdata-local.sh [-h|--help] [--version] <command> <subcommand> [options]");
            System.err.println("");
            System.err.println("Commands:");
            this.printMainUsage();
            System.err.println("");
        } else {
            String parsedCommand = this.getCommand();
            if (this.getSubCommand().isEmpty()) {
                System.err.println("");
                System.err.println("Usage:   hpg-bigdata-local.sh " + parsedCommand + " <subcommand> [options]");
                System.err.println("");
                System.err.println("Subcommands:");
                this.printCommandUsage((JCommander)this.jcommander.getCommands().get(this.getCommand()));
                System.err.println("");
            } else {
                String parsedSubCommand = this.getSubCommand();
                System.err.println("");
                System.err.println("Usage:   hpg-bigdata-local.sh " + parsedCommand + " " + parsedSubCommand + " [options]");
                System.err.println("");
                System.err.println("Options:");
                this.printSubCommandUsage((JCommander)((JCommander)this.jcommander.getCommands().get(parsedCommand)).getCommands().get(parsedSubCommand));
                System.err.println("");
            }
        }
    }

    private void printMainUsage() {
        HashMap<String, String> commandDescription = new HashMap<String, String>();
        commandDescription.put("sequence", "Implements different tools for working with Fastq files");
        commandDescription.put("alignment", "Implements different tools for working with SAM/BAM files");
        commandDescription.put("variant", "Implements different tools for working with gVCF/VCF files");
        for (String s : this.jcommander.getCommands().keySet()) {
            System.err.printf("%12s  %s\n", s, commandDescription.get(s));
        }
    }

    private void printCommandUsage(JCommander commander) {
        for (Map.Entry entry : commander.getCommands().entrySet()) {
            System.err.printf("%12s  %s\n", entry.getKey(), commander.getCommandDescription((String)entry.getKey()));
        }
    }

    private void printSubCommandUsage(JCommander commander) {
        for (ParameterDescription parameterDescription : commander.getParameters()) {
            String type = "";
            if (parameterDescription.getParameterized().getParameter().arity() > 0) {
                type = parameterDescription.getParameterized().getGenericType().getTypeName().replace("java.lang.", "").toUpperCase();
            }
            System.err.printf("%5s %-20s %-10s %s [%s]\n", parameterDescription.getParameterized().getParameter().required() ? "*" : "", parameterDescription.getNames(), type, parameterDescription.getDescription(), parameterDescription.getDefault());
        }
    }

    public GeneralOptions getGeneralOptions() {
        return this.generalOptions;
    }

    public CommandOptions getCommandOptions() {
        return this.commandOptions;
    }

    public AdminCommandOptions getAdminCommandOptions() {
        return this.adminCommandOptions;
    }

    public SequenceCommandOptions getSequenceCommandOptions() {
        return this.sequenceCommandOptions;
    }

    public AlignmentCommandOptions getAlignmentCommandOptions() {
        return this.alignmentCommandOptions;
    }

    public CommonCommandOptions getCommonCommandOptions() {
        return this.commonCommandOptions;
    }

    public VariantCommandOptions getVariantCommandOptions() {
        return this.variantCommandOptions;
    }

    @Parameters(commandNames={"query"}, commandDescription="Command to execute queries against the input file (Avro or Parquet), the results will be saved into the output file.")
    class QueryVariantCommandOptions {
        @ParametersDelegate
        public CommonCommandOptions commonOptions;
        @Parameter(names={"-i", "--input"}, description="Input file name (in Avro or Parquet format).", required=true, arity=1)
        public String input;
        @Parameter(names={"-o", "--output"}, description="Output file name.", required=true, arity=1)
        public String output;
        @Parameter(names={"--id"}, description="Query for ID; comma separated list of IDs, e.g.: \"rs312411,rs421225\"", required=false, arity=1)
        public String ids;
        @Parameter(names={"--type"}, description="Query for type; comma separated list of IDs, e.g.: \"SNP,SNV\"", required=false, arity=1)
        public String types;
        @Parameter(names={"--region"}, description="Query for region; comma separated list of regions, e.g.: 1:300000-400000000,15:343453463-8787665654", required=false)
        public String regions;
        @Parameter(names={"--consequence-type-so-accession"}, description="Query for Sequence Ontology (SO) term accession code; comma separated list of accession codes of the SO terms related to the variant consequence type, e.g.: SO:32234,SO:00124", required=false, arity=1)
        public String so_accessions;
        @Parameter(names={"--consequence-type-so-name"}, description="Query for Sequence Ontology (SO) term name; comma separated list of names of the SO terms related to the variant consequence type, e.g.:  \"transgenic insertion, genetic marker\"", required=false, arity=1)
        public String so_names;

        QueryVariantCommandOptions() {
            this.commonOptions = LocalCliOptionsParser.this.commonCommandOptions;
        }
    }

    @Parameters(commandNames={"annotate"}, commandDescription="Convert gVCF/VCF files to different big data formats such as Avro and Parquet using GA4GH models")
    class AnnotateVariantCommandOptions {
        @ParametersDelegate
        public CommonCommandOptions commonOptions;
        @Parameter(names={"-i", "--input"}, description="Input file name, usually a gVCF/VCF but it can be an Avro file when converting to Parquet.", required=true, arity=1)
        public String input;
        @Parameter(names={"-o", "--output"}, description="Input file name, usually a gVCF/VCF but it can be an Avro file when converting to Parquet.", required=true, arity=1)
        public String ouput;

        AnnotateVariantCommandOptions() {
            this.commonOptions = LocalCliOptionsParser.this.commonCommandOptions;
        }
    }

    @Parameters(commandNames={"convert"}, commandDescription="Convert gVCF/VCF files to different big data formats such as Avro and Parquet using GA4GH models")
    class ConvertVariantCommandOptions {
        @ParametersDelegate
        public CommonCommandOptions commonOptions;
        @Parameter(names={"-i", "--input"}, description="Input file name, usually a gVCF/VCF but it can be an Avro file when converting to Parquet.", required=true, arity=1)
        public String input;
        @Parameter(names={"--to"}, description="Destination Serialization format. Accepted values: avro, parquet and json", required=true)
        public String to;
        @Parameter(names={"-o", "--output"}, description="Output file name.", required=false, arity=1)
        public String output;
        @Parameter(names={"-O"}, description="Use the standard output.", required=false, arity=0)
        public boolean stdOutput;
        @Parameter(names={"--from"}, description="Accepted values: vcf, avro", required=false)
        public String from;
        @Parameter(names={"--region"}, description="Filter variant by regions, comma separated list of regions, e.g.: 1:300000-400000000,15:343453463-8787665654", required=false)
        public String regions;
        @Parameter(names={"-d", "--data-model"}, description="Only for 'to-json' and 'to-avro' options. 'to-protobuf' is only available with opencb data models. Values: opencb, ga4gh", required=false, arity=1)
        public String dataModel;
        @Parameter(names={"-x", "--compression"}, description="Available options for Avro are: : snappy, deflate, bzip2, xz. For JSON and ProtoBuf only 'gzip' is available. It compression is null,  it will be inferred compression from file extensions: .gz, .sz, ...", required=false, arity=1)
        public String compression;
        @Parameter(names={"-t", "--num-threads"}, description="Number of threads to use, this must be less than the number of cores", required=false)
        public int numThreads;
        @Parameter(names={"--skip-normalization"}, description="Whether to skip variant normalization", required=false)
        public boolean skipNormalization;
        @DynamicParameter(names={"-D"}, hidden=true)
        public Map<String, String> options;

        ConvertVariantCommandOptions() {
            this.commonOptions = LocalCliOptionsParser.this.commonCommandOptions;
            this.dataModel = "opencb";
            this.compression = "deflate";
            this.numThreads = 1;
            this.options = new HashMap<String, String>();
        }
    }

    @Parameters(commandNames={"variant"}, commandDescription="Implements different tools for working with gVCF/VCF files")
    public class VariantCommandOptions
    extends CommandOptions {
        ConvertVariantCommandOptions convertVariantCommandOptions;
        AnnotateVariantCommandOptions annotateVariantCommandOptions;
        QueryVariantCommandOptions queryVariantCommandOptions;

        public VariantCommandOptions() {
            this.convertVariantCommandOptions = new ConvertVariantCommandOptions();
            this.annotateVariantCommandOptions = new AnnotateVariantCommandOptions();
            this.queryVariantCommandOptions = new QueryVariantCommandOptions();
        }
    }

    @Parameters(commandNames={"query"}, commandDescription="Command to execute queries against the Alignment input file (Avro or Parquet), the results will be saved into the output file.")
    class QueryAlignmentCommandOptions {
        @ParametersDelegate
        public CommonCommandOptions commonOptions;
        @Parameter(names={"-i", "--input"}, description="Input file name (in Avro or Parquet format) that contains the alignments.", required=true, arity=1)
        public String input;
        @Parameter(names={"-o", "--output"}, description="Output file name.", required=true, arity=1)
        public String output;
        @Parameter(names={"--region"}, description="Query for region; comma separated list of regions, e.g.: 1:300000-400000000,15:343453463-8787665654", required=false)
        public String regions;
        @Parameter(names={"--region-file"}, description="Query for region; the list of regions is stored in this input file, one region (1:300000-400000000) per line", required=false)
        public String regionFile;
        @Parameter(names={"--min-mapq"}, description="Query for minimun mappging quality", required=false, arity=1)
        public int minMapQ;
        @Parameter(names={"--require-flags"}, description="Query for alignments matching theses flags", required=false, arity=1)
        public int requireFlags;
        @Parameter(names={"--filtering-flags"}, description="Query for alignments not matching these flags", required=false, arity=1)
        public int filteringFlags;
        @Parameter(names={"--min-tlen"}, description="Query for alignments with a template length greater than the minimun", required=false, arity=1)
        public int minTLen;
        @Parameter(names={"--max-tlen"}, description="Query for alignments with a template length less than the maximum\"", required=false, arity=1)
        public int maxTLen;
        @Parameter(names={"--min-alen"}, description="Query for alignments with an alignment length greater than the minimun", required=false, arity=1)
        public int minALen;
        @Parameter(names={"--max-alen"}, description="Query for alignments with an alignment length less than the maximum\"", required=false, arity=1)
        public int maxALen;

        QueryAlignmentCommandOptions() {
            this.commonOptions = LocalCliOptionsParser.this.commonCommandOptions;
            this.minMapQ = 0;
            this.requireFlags = 4095;
            this.filteringFlags = 0;
            this.minTLen = 0;
            this.maxTLen = Integer.MAX_VALUE;
            this.minALen = 0;
            this.maxALen = Integer.MAX_VALUE;
        }
    }

    @Parameters(commandNames={"coverage"}, commandDescription="Compute the coverage for a given file containing alignments according to the GA4GH/Avro model")
    class CoverageAlignmentCommandOptions {
        @ParametersDelegate
        public CommonCommandOptions commonOptions;
        @Parameter(names={"-i", "--input"}, description="Local input file containing alignments stored according to the GA4GH/Avro model. This file must be sorted", required=true, arity=1)
        public String input;
        @Parameter(names={"-o", "--output"}, description="Local output directory to save the coverage in a text file", required=true, arity=1)
        public String output;

        CoverageAlignmentCommandOptions() {
            this.commonOptions = LocalCliOptionsParser.this.commonCommandOptions;
            this.input = null;
            this.output = null;
        }
    }

    @Parameters(commandNames={"stats"}, commandDescription="Compute some stats for a file containing alignments according to the GA4GH/Avro model")
    class StatsAlignmentCommandOptions {
        @ParametersDelegate
        public CommonCommandOptions commonOptions;
        @Parameter(names={"-i", "--input"}, description="Local input file containing alignments stored according to the GA4GH/Avro model)", required=true, arity=1)
        public String input;
        @Parameter(names={"-o", "--output"}, description="Local output directory to save stats results in JSON format ", required=true, arity=1)
        public String output;

        StatsAlignmentCommandOptions() {
            this.commonOptions = LocalCliOptionsParser.this.commonCommandOptions;
            this.input = null;
            this.output = null;
        }
    }

    @Parameters(commandNames={"convert"}, commandDescription="Converts BAM files to different big data formats such as Avro")
    class ConvertAlignmentCommandOptions {
        @ParametersDelegate
        public CommonCommandOptions commonOptions;
        @Parameter(names={"-i", "--input"}, description="Local input file in BAM format", required=true, arity=1)
        public String input;
        @Parameter(names={"-o", "--output"}, description="Local output file to store the BAM alignments according to the GA4GH/Avro model", required=true, arity=1)
        public String output;
        @Parameter(names={"-x", "--compression"}, description="Accepted values: snappy, deflate, bzip2, xz. Default: snappy", required=false, arity=1)
        public String compression;
        @Parameter(names={"--to-bam"}, description="Convert back to BAM format. In this case, the input file has to be saved in the GA4GH/Avro model, and the output file will be in BAM format", required=false)
        public boolean toBam;
        @Parameter(names={"--adjust-quality"}, description="Compress quality field using 8 quality levels. Will loss information.", required=false)
        public boolean adjustQuality;

        ConvertAlignmentCommandOptions() {
            this.commonOptions = LocalCliOptionsParser.this.commonCommandOptions;
            this.input = null;
            this.output = null;
            this.compression = "snappy";
        }
    }

    @Parameters(commandNames={"alignment"}, commandDescription="Implements different tools for working with BAM files")
    public class AlignmentCommandOptions
    extends CommandOptions {
        ConvertAlignmentCommandOptions convertAlignmentCommandOptions;
        StatsAlignmentCommandOptions statsAlignmentCommandOptions;
        CoverageAlignmentCommandOptions coverageAlignmentCommandOptions;
        QueryAlignmentCommandOptions queryAlignmentCommandOptions;

        public AlignmentCommandOptions() {
            this.convertAlignmentCommandOptions = new ConvertAlignmentCommandOptions();
            this.statsAlignmentCommandOptions = new StatsAlignmentCommandOptions();
            this.coverageAlignmentCommandOptions = new CoverageAlignmentCommandOptions();
            this.queryAlignmentCommandOptions = new QueryAlignmentCommandOptions();
        }
    }

    @Parameters(commandNames={"stats"}, commandDescription="Calculates different stats from sequencing data")
    class StatsSequenceCommandOptions {
        @ParametersDelegate
        public CommonCommandOptions commonOptions;
        @Parameter(names={"-i", "--input"}, description="Local input file containing the FastQ sequences stored according to the GA4GH/Avro model)", required=true, arity=1)
        public String input;
        @Parameter(names={"-o", "--output"}, description="Local output directory to save stats results in JSON format ", required=true, arity=1)
        public String output;
        @Parameter(names={"-k", "--kmers"}, description="Compute k-mers (according to the indicated length)", required=false, arity=1)
        public Integer kmers;

        StatsSequenceCommandOptions() {
            this.commonOptions = LocalCliOptionsParser.this.commonCommandOptions;
            this.input = null;
            this.output = null;
            this.kmers = 0;
        }
    }

    @Parameters(commandNames={"convert"}, commandDescription="Converts FastQ files to different big data formats such as Avro")
    class ConvertSequenceCommandOptions {
        @ParametersDelegate
        public CommonCommandOptions commonOptions;
        @Parameter(names={"-i", "--input"}, description="Local input file in FastQ format", required=true, arity=1)
        public String input;
        @Parameter(names={"-o", "--output"}, description="Local output file to store the FastQ sequences according to the GA4GH/Avro model", required=true, arity=1)
        public String output;
        @Parameter(names={"-x", "--compression"}, description="Accepted values: snappy, deflate, bzip2, xz, null. Default: snappy", required=false, arity=1)
        public String compression;

        ConvertSequenceCommandOptions() {
            this.commonOptions = LocalCliOptionsParser.this.commonCommandOptions;
            this.input = null;
            this.output = null;
            this.compression = "snappy";
        }
    }

    @Parameters(commandNames={"sequence"}, commandDescription="Implements different tools for working with Fastq files")
    public class SequenceCommandOptions
    extends CommandOptions {
        ConvertSequenceCommandOptions convertSequenceCommandOptions;
        StatsSequenceCommandOptions statsSequenceCommandOptions;

        public SequenceCommandOptions() {
            this.convertSequenceCommandOptions = new ConvertSequenceCommandOptions();
            this.statsSequenceCommandOptions = new StatsSequenceCommandOptions();
        }
    }

    @Parameters(commandNames={"server"}, commandDescription="Converts FastQ files to different big data formats such as Avro")
    class ServerAdminCommandOptions {
        @ParametersDelegate
        public CommonCommandOptions commonOptions;
        @Parameter(names={"-p", "--port"}, description="Input file name, usually a gVCF/VCF but it can be an Avro file when converting to Parquet.", required=true, arity=1)
        public int port;

        ServerAdminCommandOptions() {
            this.commonOptions = LocalCliOptionsParser.this.commonCommandOptions;
            this.port = 1042;
        }
    }

    @Parameters(commandNames={"admin"}, commandDescription="Implements different tools for working with Fastq files")
    public class AdminCommandOptions
    extends CommandOptions {
        ServerAdminCommandOptions serverAdminCommandOptions;

        public AdminCommandOptions() {
            this.serverAdminCommandOptions = new ServerAdminCommandOptions();
        }
    }

    public class CommonCommandOptions {
        @Parameter(names={"-h", "--help"}, description="This parameter prints this help", help=true)
        public boolean help;
        @Parameter(names={"-L", "--log-level"}, description="Set the level log, values: debug, info, warning, error, fatal", required=false, arity=1)
        public String logLevel = "info";
        @Deprecated
        @Parameter(names={"-v", "--verbose"}, description="This parameter set the level of the logging", required=false, arity=1)
        public boolean verbose;
        @Parameter(names={"--conf"}, description="Set the configuration file", required=false, arity=1)
        public String conf;
    }

    public class CommandOptions {
        @Parameter(names={"-h", "--help"}, description="This parameter prints this help", help=true)
        public boolean help;

        public JCommander getSubCommand() {
            return (JCommander)((JCommander)LocalCliOptionsParser.this.jcommander.getCommands().get(LocalCliOptionsParser.this.getCommand())).getCommands().get(this.getSubCommand());
        }

        public String getParsedSubCommand() {
            String parsedCommand = LocalCliOptionsParser.this.jcommander.getParsedCommand();
            if (LocalCliOptionsParser.this.jcommander.getCommands().containsKey(parsedCommand)) {
                String subCommand = ((JCommander)LocalCliOptionsParser.this.jcommander.getCommands().get(parsedCommand)).getParsedCommand();
                return subCommand != null ? subCommand : "";
            }
            return "";
        }
    }

    public class GeneralOptions {
        @Parameter(names={"-h", "--help"}, description="This parameter prints this help", help=true)
        public boolean help;
        @Parameter(names={"--version"})
        public boolean version;
    }
}

