/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.app.cli.local;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.util.LineReader;
import htsjdk.samtools.util.StringLineReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.io.DatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SparkSession;
import org.ga4gh.models.ReadAlignment;
import org.opencb.biodata.models.alignment.RegionCoverage;
import org.opencb.biodata.models.core.Region;
import org.opencb.biodata.tools.alignment.AlignmentOptions;
import org.opencb.biodata.tools.alignment.BamManager;
import org.opencb.biodata.tools.alignment.BamUtils;
import org.opencb.biodata.tools.alignment.stats.AlignmentGlobalStats;
import org.opencb.commons.utils.FileUtils;
import org.opencb.hpg.bigdata.app.cli.CommandExecutor;
import org.opencb.hpg.bigdata.app.cli.local.LocalCliOptionsParser;
import org.opencb.hpg.bigdata.core.avro.AlignmentAvroSerializer;
import org.opencb.hpg.bigdata.core.converters.SAMRecord2ReadAlignmentConverter;
import org.opencb.hpg.bigdata.core.lib.AlignmentDataset;
import org.opencb.hpg.bigdata.core.lib.SparkConfCreator;

public class AlignmentCommandExecutor
extends CommandExecutor {
    private LocalCliOptionsParser.AlignmentCommandOptions alignmentCommandOptions;
    public static final String BAM_HEADER_SUFFIX = ".header";

    public AlignmentCommandExecutor(LocalCliOptionsParser.AlignmentCommandOptions alignmentCommandOptions) {
        this.alignmentCommandOptions = alignmentCommandOptions;
    }

    @Override
    public void execute() throws Exception {
        String subCommand;
        switch (subCommand = this.alignmentCommandOptions.getParsedSubCommand()) {
            case "convert": {
                this.init(this.alignmentCommandOptions.convertAlignmentCommandOptions.commonOptions.logLevel, this.alignmentCommandOptions.convertAlignmentCommandOptions.commonOptions.verbose, this.alignmentCommandOptions.convertAlignmentCommandOptions.commonOptions.conf);
                this.convert();
                break;
            }
            case "stats": {
                this.init(this.alignmentCommandOptions.statsAlignmentCommandOptions.commonOptions.logLevel, this.alignmentCommandOptions.statsAlignmentCommandOptions.commonOptions.verbose, this.alignmentCommandOptions.statsAlignmentCommandOptions.commonOptions.conf);
                this.stats();
                break;
            }
            case "coverage": {
                this.init(this.alignmentCommandOptions.coverageAlignmentCommandOptions.commonOptions.logLevel, this.alignmentCommandOptions.coverageAlignmentCommandOptions.commonOptions.verbose, this.alignmentCommandOptions.coverageAlignmentCommandOptions.commonOptions.conf);
                this.coverage();
                break;
            }
            case "query": {
                this.init(this.alignmentCommandOptions.queryAlignmentCommandOptions.commonOptions.logLevel, this.alignmentCommandOptions.queryAlignmentCommandOptions.commonOptions.verbose, this.alignmentCommandOptions.queryAlignmentCommandOptions.commonOptions.conf);
                this.query();
                break;
            }
        }
    }

    private void convert() throws IOException {
        String input = this.alignmentCommandOptions.convertAlignmentCommandOptions.input;
        String output = this.alignmentCommandOptions.convertAlignmentCommandOptions.output;
        String compressionCodecName = this.alignmentCommandOptions.convertAlignmentCommandOptions.compression;
        if (compressionCodecName.equals("null")) {
            compressionCodecName = "deflate";
        }
        if (this.alignmentCommandOptions.convertAlignmentCommandOptions.toBam) {
            File file = new File(input + BAM_HEADER_SUFFIX);
            FileInputStream fis = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            fis.read(data);
            fis.close();
            FileInputStream is = new FileInputStream(input);
            String textHeader = new String(data);
            StringLineReader lineReader = new StringLineReader(textHeader);
            SAMFileHeader header = new SAMTextHeaderCodec().decode((LineReader)lineReader, textHeader);
            DataFileStream reader = new DataFileStream((InputStream)is, (DatumReader)new SpecificDatumReader(ReadAlignment.class));
            FileOutputStream os = new FileOutputStream(new File(output));
            SAMFileWriter writer = new SAMFileWriterFactory().makeBAMWriter(header, false, new File(output));
            int reads = 0;
            SAMRecord2ReadAlignmentConverter converter = new SAMRecord2ReadAlignmentConverter();
            for (ReadAlignment readAlignment : reader) {
                SAMRecord samRecord = converter.backward(readAlignment);
                samRecord.setHeader(header);
                writer.addAlignment(samRecord);
                if (++reads % 100000 != 0) continue;
                System.out.println("Converted " + reads + " reads");
            }
            reader.close();
            writer.close();
            ((OutputStream)os).close();
            ((InputStream)is).close();
        } else {
            boolean adjustQuality = this.alignmentCommandOptions.convertAlignmentCommandOptions.adjustQuality;
            AlignmentAvroSerializer avroSerializer = new AlignmentAvroSerializer(compressionCodecName);
            avroSerializer.toAvro(input, output);
        }
    }

    private void stats() throws Exception {
        String input = this.alignmentCommandOptions.statsAlignmentCommandOptions.input;
        String output = this.alignmentCommandOptions.statsAlignmentCommandOptions.output;
        BamManager alignmentManager = new BamManager(Paths.get(input, new String[0]));
        AlignmentGlobalStats stats = alignmentManager.stats();
        alignmentManager.close();
        PrintWriter writer = new PrintWriter(new File(output + "/stats.json"));
        writer.write(stats.toJSON());
        writer.close();
    }

    private void coverage() throws IOException {
        int chunkSize = 10000;
        String input = this.alignmentCommandOptions.coverageAlignmentCommandOptions.input;
        String output = this.alignmentCommandOptions.coverageAlignmentCommandOptions.output;
        Path filePath = Paths.get(input, new String[0]);
        PrintWriter writer = new PrintWriter(new File(output + "/" + filePath.getFileName() + ".coverage"));
        SAMFileHeader fileHeader = BamUtils.getFileHeader((Path)filePath);
        AlignmentOptions options = new AlignmentOptions();
        options.setContained(false);
        BamManager alignmentManager = new BamManager(filePath);
        for (SAMSequenceRecord next : fileHeader.getSequenceDictionary().getSequences()) {
            for (int i = 0; i < next.getSequenceLength(); i += 10000) {
                Region region = new Region(next.getSequenceName(), i + 1, Math.min(i + 10000, next.getSequenceLength()));
                RegionCoverage regionCoverage = alignmentManager.coverage(region, null, options);
                short[] values = regionCoverage.getValues();
                int j = 0;
                int start = region.getStart();
                while (j < values.length) {
                    if (values[j] > 0) {
                        writer.write(next.getSequenceName() + "\t" + start + "\t" + values[j] + "\n");
                    }
                    ++j;
                    ++start;
                }
            }
        }
        writer.close();
    }

    public void query() throws Exception {
        Path inputPath = Paths.get(this.alignmentCommandOptions.queryAlignmentCommandOptions.input, new String[0]);
        FileUtils.checkFile((Path)inputPath);
        SparkConf sparkConf = SparkConfCreator.getConf((String)"variant query", (String)"local", (int)1, (boolean)true, (String)"/home/jtarraga/soft/spark-2.0.0/");
        System.out.println("sparkConf = " + sparkConf.toDebugString());
        SparkSession sparkSession = new SparkSession(new SparkContext(sparkConf));
        AlignmentDataset ad = new AlignmentDataset();
        ad.load(this.alignmentCommandOptions.queryAlignmentCommandOptions.input, sparkSession);
        ad.createOrReplaceTempView("alignment");
        List regions = null;
        if (StringUtils.isNotEmpty((CharSequence)this.alignmentCommandOptions.queryAlignmentCommandOptions.regions)) {
            regions = Region.parseRegions((String)this.alignmentCommandOptions.queryAlignmentCommandOptions.regions);
            ad.regionFilter(regions);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.alignmentCommandOptions.queryAlignmentCommandOptions.regionFile)) {
            this.logger.warn("Query for region file, not yet implemented.");
        }
        if (this.alignmentCommandOptions.queryAlignmentCommandOptions.minMapQ > 0) {
            ad.mappingQualityFilter(">=" + this.alignmentCommandOptions.queryAlignmentCommandOptions.minMapQ);
        }
        if (this.alignmentCommandOptions.queryAlignmentCommandOptions.requireFlags != Integer.MAX_VALUE) {
            ad.flagFilter("" + this.alignmentCommandOptions.queryAlignmentCommandOptions.requireFlags, Boolean.valueOf(false));
        }
        if (this.alignmentCommandOptions.queryAlignmentCommandOptions.filteringFlags != 0) {
            ad.flagFilter("" + this.alignmentCommandOptions.queryAlignmentCommandOptions.filteringFlags, Boolean.valueOf(true));
        }
        if (this.alignmentCommandOptions.queryAlignmentCommandOptions.minTLen != 0) {
            ad.templateLengthFilter(">=" + this.alignmentCommandOptions.queryAlignmentCommandOptions.minTLen);
        }
        if (this.alignmentCommandOptions.queryAlignmentCommandOptions.maxTLen != Integer.MAX_VALUE) {
            ad.templateLengthFilter("<=" + this.alignmentCommandOptions.queryAlignmentCommandOptions.maxTLen);
        }
        if (this.alignmentCommandOptions.queryAlignmentCommandOptions.minALen != 0) {
            ad.alignmentLengthFilter(">=" + this.alignmentCommandOptions.queryAlignmentCommandOptions.minALen);
        }
        if (this.alignmentCommandOptions.queryAlignmentCommandOptions.maxALen != Integer.MAX_VALUE) {
            ad.alignmentLengthFilter("<=" + this.alignmentCommandOptions.queryAlignmentCommandOptions.maxALen);
        }
        ad.update();
        this.logger.warn("The current query implementation saves the resulting dataset in Avro format.");
        ad.write().format("com.databricks.spark.avro").save(this.alignmentCommandOptions.queryAlignmentCommandOptions.output);
    }
}

