/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.app.cli.hadoop;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.mapreduce.Job;
import org.opencb.hpg.bigdata.analysis.variant.Variant2HbaseMR;
import org.opencb.hpg.bigdata.app.cli.CommandExecutor;
import org.opencb.hpg.bigdata.app.cli.hadoop.CliOptionsParser;

public class VariantCommandExecutor
extends CommandExecutor {
    private CliOptionsParser.VariantCommandOptions variantCommandOptions;

    public VariantCommandExecutor(CliOptionsParser.VariantCommandOptions variantCommandOptions) {
        this.variantCommandOptions = variantCommandOptions;
    }

    @Override
    public void execute() throws Exception {
        String subCommandString;
        switch (subCommandString = this.variantCommandOptions.getParsedSubCommand()) {
            case "convert": {
                this.init(this.variantCommandOptions.convertVariantCommandOptions.commonOptions.logLevel, this.variantCommandOptions.convertVariantCommandOptions.commonOptions.verbose, this.variantCommandOptions.convertVariantCommandOptions.commonOptions.conf);
                this.convert();
            }
            case "index": {
                this.init(this.variantCommandOptions.indexVariantCommandOptions.commonOptions.logLevel, this.variantCommandOptions.indexVariantCommandOptions.commonOptions.verbose, this.variantCommandOptions.indexVariantCommandOptions.commonOptions.conf);
                this.index();
                break;
            }
        }
    }

    private void index() throws Exception {
        String input = this.variantCommandOptions.indexVariantCommandOptions.input;
        String db = this.variantCommandOptions.indexVariantCommandOptions.database;
        boolean nonVar = this.variantCommandOptions.indexVariantCommandOptions.includeNonVariants;
        boolean expand = this.variantCommandOptions.indexVariantCommandOptions.expand;
        URI server = null;
        if (StringUtils.isNotBlank((CharSequence)db)) {
            server = new URI(db);
        }
        Variant2HbaseMR.Builder builder = new Variant2HbaseMR.Builder(input, server);
        builder.setExpand(expand);
        builder.setNonVar(nonVar);
        Job job = builder.build(true);
        boolean fine = job.waitForCompletion(true);
        if (!fine) {
            throw new IllegalStateException("Variant 2 HBase failed!");
        }
    }

    private void convert() throws Exception {
    }
}

