/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.app.cli.hadoop;

import java.io.IOException;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.opencb.hpg.bigdata.analysis.sequence.Fastq2AvroMR;
import org.opencb.hpg.bigdata.analysis.sequence.stats.ReadKmersMR;
import org.opencb.hpg.bigdata.analysis.sequence.stats.ReadStatsMR;
import org.opencb.hpg.bigdata.app.cli.CommandExecutor;
import org.opencb.hpg.bigdata.app.cli.hadoop.CliOptionsParser;
import org.opencb.hpg.bigdata.core.utils.PathUtils;

public class SequenceCommandExecutor
extends CommandExecutor {
    private CliOptionsParser.SequenceCommandOptions sequenceCommandOptions;

    public SequenceCommandExecutor(CliOptionsParser.SequenceCommandOptions sequenceCommandOptions) {
        this.sequenceCommandOptions = sequenceCommandOptions;
    }

    @Override
    public void execute() throws Exception {
        String subCommand;
        switch (subCommand = this.sequenceCommandOptions.getParsedSubCommand()) {
            case "convert": {
                this.convert();
                break;
            }
            case "stats": {
                this.stats();
                break;
            }
            case "align": {
                System.out.println("Sub-command 'align': Not yet implemented for the command 'sequence' !");
                break;
            }
        }
    }

    private void convert() throws Exception {
        CliOptionsParser.ConvertSequenceCommandOptions convertSequenceCommandOptions = this.sequenceCommandOptions.convertSequenceCommandOptions;
        String input = convertSequenceCommandOptions.input;
        String output = convertSequenceCommandOptions.output;
        String codecName = convertSequenceCommandOptions.compression;
        if (codecName.equals("null")) {
            codecName = null;
        }
        Fastq2AvroMR.run((String)input, (String)output, (String)codecName);
    }

    private void stats() throws Exception {
        CliOptionsParser.StatsSequenceCommandOptions statsSequenceCommandOptions = this.sequenceCommandOptions.statsSequenceCommandOptions;
        String input = statsSequenceCommandOptions.input;
        String output = statsSequenceCommandOptions.output;
        int kvalue = statsSequenceCommandOptions.kmers;
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        String outHdfsDirname = Long.toString(new Date().getTime());
        ReadStatsMR.run((String)input, (String)outHdfsDirname, (int)kvalue);
        Path outFile = new Path(outHdfsDirname + "/part-r-00000");
        if (!fs.exists(outFile)) {
            this.logger.error("Stats results file not found: {}", (Object)outFile.getName());
        } else {
            String outRawFileName = output + "/stats.json";
            fs.copyToLocalFile(outFile, new Path(outRawFileName));
        }
        fs.delete(new Path(outHdfsDirname), true);
    }

    @Deprecated
    private void kmers(String input, String output, int kvalue) throws Exception {
        String in = PathUtils.clean((String)input);
        String out = PathUtils.clean((String)output);
        if (!PathUtils.isHdfs((String)input)) {
            throw new IOException("To run fastq kmers, input files '" + input + "' must be stored in the HDFS/Haddop. Use the command 'convert fastq2sa' to import your file.");
        }
        ReadKmersMR.run((String)in, (String)out, (int)kvalue);
    }
}

