/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.app.cli.hadoop;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.util.HashMap;
import java.util.Map;

public class CliOptionsParser {
    private final JCommander jcommander;
    private final GeneralOptions generalOptions = new GeneralOptions();
    private final CommandOptions commandOptions;
    private final CommonCommandOptions commonCommandOptions;
    private SequenceCommandOptions sequenceCommandOptions;
    private AlignmentCommandOptions alignmentCommandOptions;
    private VariantCommandOptions variantCommandOptions;

    public CliOptionsParser() {
        this.jcommander = new JCommander((Object)this.generalOptions);
        this.commandOptions = new CommandOptions();
        this.commonCommandOptions = new CommonCommandOptions();
        this.sequenceCommandOptions = new SequenceCommandOptions();
        this.jcommander.addCommand("sequence", (Object)this.sequenceCommandOptions);
        JCommander sequenceSubCommands = (JCommander)this.jcommander.getCommands().get("sequence");
        sequenceSubCommands.addCommand("convert", (Object)this.sequenceCommandOptions.convertSequenceCommandOptions);
        sequenceSubCommands.addCommand("stats", (Object)this.sequenceCommandOptions.statsSequenceCommandOptions);
        this.alignmentCommandOptions = new AlignmentCommandOptions();
        this.jcommander.addCommand("alignment", (Object)this.sequenceCommandOptions);
        JCommander alignmentSubCommands = (JCommander)this.jcommander.getCommands().get("alignment");
        alignmentSubCommands.addCommand("convert", (Object)this.alignmentCommandOptions.convertAlignmentCommandOptions);
        alignmentSubCommands.addCommand("stats", (Object)this.alignmentCommandOptions.statsAlignmentCommandOptions);
        alignmentSubCommands.addCommand("depth", (Object)this.alignmentCommandOptions.depthAlignmentCommandOptions);
        this.variantCommandOptions = new VariantCommandOptions();
        this.jcommander.addCommand("variant", (Object)this.sequenceCommandOptions);
        JCommander variantSubCommands = (JCommander)this.jcommander.getCommands().get("variant");
        variantSubCommands.addCommand("convert", (Object)this.variantCommandOptions.convertVariantCommandOptions);
        variantSubCommands.addCommand("index", (Object)this.variantCommandOptions.indexVariantCommandOptions);
    }

    public void parse(String[] args) throws ParameterException {
        this.jcommander.parse(args);
    }

    public String getCommand() {
        return this.jcommander.getParsedCommand() != null ? this.jcommander.getParsedCommand() : "";
    }

    public String getSubCommand() {
        String parsedCommand = this.jcommander.getParsedCommand();
        if (this.jcommander.getCommands().containsKey(parsedCommand)) {
            String subCommand = ((JCommander)this.jcommander.getCommands().get(parsedCommand)).getParsedCommand();
            return subCommand != null ? subCommand : "";
        }
        return null;
    }

    public void printUsage() {
        if (this.getCommand().isEmpty()) {
            System.err.println("");
            System.err.println("Program:     HPG BigData for Hadoop (OpenCB)");
            System.err.println("Version:     0.2.0");
            System.err.println("Description: Hadoop-based tools for working with NGS data");
            System.err.println("");
            System.err.println("Usage:       hpg-bigdata.sh [-h|--help] [--version] <command> <subcommand> [options]");
            System.err.println("");
            System.err.println("Commands:");
            this.printMainUsage();
            System.err.println("");
        } else {
            String parsedCommand = this.getCommand();
            if (this.getSubCommand().isEmpty()) {
                System.err.println("");
                System.err.println("Usage:   hpg-bigdata.sh " + parsedCommand + " <subcommand> [options]");
                System.err.println("");
                System.err.println("Subcommands:");
                this.printCommandUsage((JCommander)this.jcommander.getCommands().get(this.getCommand()));
                System.err.println("");
            } else {
                String parsedSubCommand = this.getSubCommand();
                System.err.println("");
                System.err.println("Usage:   hpg-bigdata.sh " + parsedCommand + " " + parsedSubCommand + " [options]");
                System.err.println("");
                System.err.println("Options:");
                this.printSubCommandUsage((JCommander)((JCommander)this.jcommander.getCommands().get(parsedCommand)).getCommands().get(parsedSubCommand));
                System.err.println("");
            }
        }
    }

    private void printMainUsage() {
        HashMap<String, String> commandDescription = new HashMap<String, String>();
        commandDescription.put("sequence", "Implements different tools for working with Fastq files");
        commandDescription.put("alignment", "Implements different tools for working with SAM/BAM files");
        commandDescription.put("variant", "Implements different tools for working with gVCF/VCF files");
        for (String s : this.jcommander.getCommands().keySet()) {
            System.err.printf("%12s  %s\n", s, commandDescription.get(s));
        }
    }

    private void printCommandUsage(JCommander commander) {
        for (Map.Entry entry : commander.getCommands().entrySet()) {
            System.err.printf("%12s  %s\n", entry.getKey(), commander.getCommandDescription((String)entry.getKey()));
        }
    }

    private void printSubCommandUsage(JCommander commander) {
        for (ParameterDescription parameterDescription : commander.getParameters()) {
            String type = "";
            if (parameterDescription.getParameterized().getParameter().arity() > 0) {
                type = parameterDescription.getParameterized().getGenericType().getTypeName().replace("java.lang.", "").toUpperCase();
            }
            System.err.printf("%5s %-20s %-10s %s [%s]\n", parameterDescription.getParameterized().getParameter().required() ? "*" : "", parameterDescription.getNames(), type, parameterDescription.getDescription(), parameterDescription.getDefault());
        }
    }

    public GeneralOptions getGeneralOptions() {
        return this.generalOptions;
    }

    public CommandOptions getCommandOptions() {
        return this.commandOptions;
    }

    public CommonCommandOptions getCommonCommandOptions() {
        return this.commonCommandOptions;
    }

    public SequenceCommandOptions getSequenceCommandOptions() {
        return this.sequenceCommandOptions;
    }

    public AlignmentCommandOptions getAlignmentCommandOptions() {
        return this.alignmentCommandOptions;
    }

    public VariantCommandOptions getVariantCommandOptions() {
        return this.variantCommandOptions;
    }

    @Parameters(commandNames={"index"}, commandDescription="Load avro gVCF/VCF files into different NoSQL, only HBase implemented so far")
    public class IndexVariantCommandOptions {
        @ParametersDelegate
        public CommonCommandOptions commonOptions;
        @Parameter(names={"-i", "--input"}, description="GA4GH Avro input file", required=true, arity=1)
        public String input;
        @Parameter(names={"-t", "--type"}, description="Type can be: vcf, bed, or gff", arity=1)
        public String type;
        @Parameter(names={"-se", "--storage-engine"}, description="Database, values: hbase, hive, impala", arity=1)
        public String database;
        @Parameter(names={"-r", "--regions"}, description="Database to load data, values: hbase", arity=1)
        public String regions;
        @Parameter(names={"-g", "--genome"}, description="Load whole genome from gVCF - including non-variant regions", required=false, arity=1)
        public boolean includeNonVariants;
        @Parameter(names={"-e", "--expand"}, description="Expand non-variant gVCF regions to one entry per base", required=false, arity=1)
        public boolean expand;
        @Parameter(names={"--credentials"}, description="Database credentials: user, password, host, port", arity=1)
        public String credentials;

        public IndexVariantCommandOptions() {
            this.commonOptions = CliOptionsParser.this.commonCommandOptions;
            this.input = null;
            this.type = "vcf";
            this.database = "hbase";
            this.regions = null;
            this.includeNonVariants = false;
            this.expand = false;
        }
    }

    @Parameters(commandNames={"convert"}, commandDescription="Convert gVCF/VCF files to different data formats such as Avro, Parquet and Json.")
    class ConvertVariantCommandOptions {
        @ParametersDelegate
        public CommonCommandOptions commonOptions;
        @Parameter(names={"-i", "--input"}, description="Input file name, usually a gVCF/VCF but it can be an Avro file when converting to Parquet.", required=true, arity=1)
        public String input;
        @Parameter(names={"--to"}, description="Destination Serialization format. Accepted values: avro, parquet and json", required=true)
        public String to;
        @Parameter(names={"-o", "--output"}, description="Output file name.", required=false, arity=1)
        public String output;
        @Parameter(names={"-O"}, description="Use the standard output.", required=false, arity=0)
        public boolean stdOutput;
        @Parameter(names={"--from"}, description="Accepted values: vcf, avro", required=false)
        public String from;
        @Parameter(names={"-x", "--compression"}, description="Only for commands 'to-avro' and 'to-parquet'. Values: snappy, deflate, bzip2, xz", required=false, arity=1)
        public String compression;
        @Parameter(names={"--region"}, description="Filter variant by regions, comma separated list of regions, e.g.: 1:300000-400000000,15:343453463-8787665654", required=false)
        public String regions;

        ConvertVariantCommandOptions() {
            this.commonOptions = CliOptionsParser.this.commonCommandOptions;
            this.compression = "snappy";
        }
    }

    @Parameters(commandNames={"variant"}, commandDescription="Implements different tools for working with gVCF/VCF files")
    public class VariantCommandOptions
    extends CommandOptions {
        ConvertVariantCommandOptions convertVariantCommandOptions;
        IndexVariantCommandOptions indexVariantCommandOptions;

        public VariantCommandOptions() {
            this.convertVariantCommandOptions = new ConvertVariantCommandOptions();
            this.indexVariantCommandOptions = new IndexVariantCommandOptions();
        }
    }

    @Parameters(commandNames={"depth"}, commandDescription="Compute the depth for a given file containing alignments in GA4GH/Avro model")
    class DepthAlignmentCommandOptions {
        @ParametersDelegate
        public CommonCommandOptions commonOptions;
        @Parameter(names={"-i", "--input"}, description="HDFS input file containing alignments stored according to the GA4GH/Avro model)", required=true, arity=1)
        public String input;
        @Parameter(names={"-o", "--output"}, description="Local output directory to save the depth in a text file", required=true, arity=1)
        public String output;
        @Parameter(names={"-r", "--regions"}, description="Compute depth for the mentioned regions separated by commas. The region format is: chromosome:start-end. Example: 3:230000000-250000000,12:435050000-435100000", required=false, arity=1)
        public String regions;
        @Parameter(names={"-q", "--min-mapq"}, description="Compute depth for alignments whose mapping quality is greater that this minimum mapping quality", required=false, arity=1)
        public int minMapQ;

        DepthAlignmentCommandOptions() {
            this.commonOptions = CliOptionsParser.this.commonCommandOptions;
            this.input = null;
            this.output = null;
            this.regions = null;
            this.minMapQ = 0;
        }
    }

    @Parameters(commandNames={"stats"}, commandDescription="Compute some stats for a file containing alignments in GA4GH/Avro model")
    class StatsAlignmentCommandOptions {
        @ParametersDelegate
        public CommonCommandOptions commonOptions;
        @Parameter(names={"-i", "--input"}, description="HDFS input file containing alignments stored according to the GA4GH/Avro model)", required=true, arity=1)
        public String input;
        @Parameter(names={"-o", "--output"}, description="Local output directory to save stats results in JSON format", required=true, arity=1)
        public String output;

        StatsAlignmentCommandOptions() {
            this.commonOptions = CliOptionsParser.this.commonCommandOptions;
            this.input = null;
            this.output = null;
        }
    }

    @Parameters(commandNames={"convert"}, commandDescription="Converts BAM files to different big data formats such as Avro and Parquet")
    class ConvertAlignmentCommandOptions {
        @ParametersDelegate
        public CommonCommandOptions commonOptions;
        @Parameter(names={"-i", "--input"}, description="HDFS input file in BAM format", required=true, arity=1)
        public String input;
        @Parameter(names={"-o", "--output"}, description="HDFS output file to store the BAM alignments according to the GA4GH/Avro model", required=true, arity=1)
        public String output;
        @Parameter(names={"-x", "--compression"}, description="Accepted values: snappy, deflate, bzip2, xz, null. Default: snappy", required=false, arity=1)
        public String compression;
        @Parameter(names={"--to-parquet"}, description="To save the output file in Parquet", required=false)
        public boolean toParquet;
        @Parameter(names={"--adjust-quality"}, description="Compress quality field using 8 quality levels. Will loss information", required=false)
        public boolean adjustQuality;

        ConvertAlignmentCommandOptions() {
            this.commonOptions = CliOptionsParser.this.commonCommandOptions;
            this.input = null;
            this.output = null;
            this.compression = "snappy";
        }
    }

    @Parameters(commandNames={"alignment"}, commandDescription="Implements different tools for working with BAM files")
    public class AlignmentCommandOptions
    extends CommandOptions {
        ConvertAlignmentCommandOptions convertAlignmentCommandOptions;
        StatsAlignmentCommandOptions statsAlignmentCommandOptions;
        DepthAlignmentCommandOptions depthAlignmentCommandOptions;

        public AlignmentCommandOptions() {
            this.convertAlignmentCommandOptions = new ConvertAlignmentCommandOptions();
            this.statsAlignmentCommandOptions = new StatsAlignmentCommandOptions();
            this.depthAlignmentCommandOptions = new DepthAlignmentCommandOptions();
        }
    }

    @Parameters(commandNames={"align"}, commandDescription="Align reads to a reference genome using HPG Aligner in MapReduce")
    public class AlignSequenceCommandOptions {
        @ParametersDelegate
        public CommonCommandOptions commonOptions;
        @Parameter(names={"-i", "--input"}, description="", required=true, arity=1)
        public String input;
        @Parameter(names={"-o", "--output"}, description="", required=false, arity=1)
        public String output;
        @Parameter(names={"--index-file"}, description="", required=false)
        public String referenceGenomeFile;

        public AlignSequenceCommandOptions() {
            this.commonOptions = CliOptionsParser.this.commonCommandOptions;
            this.input = null;
            this.output = null;
        }
    }

    @Parameters(commandNames={"stats"}, commandDescription="Calculates different stats from sequencing data")
    class StatsSequenceCommandOptions {
        @ParametersDelegate
        public CommonCommandOptions commonOptions;
        @Parameter(names={"-i", "--input"}, description="HDFS input file containing the FastQ sequences stored in GA4GH/Avro model)", required=true, arity=1)
        public String input;
        @Parameter(names={"-o", "--output"}, description="Local output directory to save stats results in JSON format ", required=true, arity=1)
        public String output;
        @Parameter(names={"-k", "--kmers"}, description="Compute k-mers (according to the indicated length)", required=false, arity=1)
        public Integer kmers;

        StatsSequenceCommandOptions() {
            this.commonOptions = CliOptionsParser.this.commonCommandOptions;
            this.input = null;
            this.output = null;
            this.kmers = 0;
        }
    }

    @Parameters(commandNames={"convert"}, commandDescription="Converts FastQ files to different big data formats such as Avro")
    class ConvertSequenceCommandOptions {
        @ParametersDelegate
        public CommonCommandOptions commonOptions;
        @Parameter(names={"-i", "--input"}, description="HDFS input file in FastQ format", required=true, arity=1)
        public String input;
        @Parameter(names={"-o", "--output"}, description="HDFS output file to store the FastQ sequences according to the GA4GH/Avro model", required=true, arity=1)
        public String output;
        @Parameter(names={"-x", "--compression"}, description="Accepted values: snappy, deflate, bzip2, xz, null. Default: snappy", required=false, arity=1)
        public String compression;

        ConvertSequenceCommandOptions() {
            this.commonOptions = CliOptionsParser.this.commonCommandOptions;
            this.input = null;
            this.output = null;
            this.compression = "snappy";
        }
    }

    @Parameters(commandNames={"sequence"}, commandDescription="Implements different tools for working with Fastq files")
    public class SequenceCommandOptions
    extends CommandOptions {
        ConvertSequenceCommandOptions convertSequenceCommandOptions;
        StatsSequenceCommandOptions statsSequenceCommandOptions;
        AlignSequenceCommandOptions alignSequenceCommandOptions;

        public SequenceCommandOptions() {
            this.convertSequenceCommandOptions = new ConvertSequenceCommandOptions();
            this.statsSequenceCommandOptions = new StatsSequenceCommandOptions();
            this.alignSequenceCommandOptions = new AlignSequenceCommandOptions();
        }
    }

    public class CommonCommandOptions {
        @Parameter(names={"-h", "--help"}, description="This parameter prints this help", help=true)
        public boolean help;
        @Parameter(names={"-L", "--log-level"}, description="Set the level log, values: debug, info, warning, error, fatal", required=false, arity=1)
        public String logLevel = "info";
        @Deprecated
        @Parameter(names={"-v", "--verbose"}, description="This parameter set the level of the logging", required=false, arity=1)
        public boolean verbose;
        @Parameter(names={"--conf"}, description="Set the configuration file", required=false, arity=1)
        public String conf;
    }

    public class CommandOptions {
        @Parameter(names={"-h", "--help"}, description="This parameter prints this help", help=true)
        public boolean help;

        public JCommander getSubCommand() {
            return (JCommander)((JCommander)CliOptionsParser.this.jcommander.getCommands().get(CliOptionsParser.this.getCommand())).getCommands().get(this.getSubCommand());
        }

        public String getParsedSubCommand() {
            String parsedCommand = CliOptionsParser.this.jcommander.getParsedCommand();
            if (CliOptionsParser.this.jcommander.getCommands().containsKey(parsedCommand)) {
                String subCommand = ((JCommander)CliOptionsParser.this.jcommander.getCommands().get(parsedCommand)).getParsedCommand();
                return subCommand != null ? subCommand : "";
            }
            return "";
        }
    }

    public class GeneralOptions {
        @Parameter(names={"-h", "--help"}, description="This parameter prints this help", help=true)
        public boolean help;
        @Parameter(names={"--version"})
        public boolean version;
    }
}

