/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.app.cli.hadoop;

import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.ga4gh.models.ReadAlignment;
import org.opencb.hpg.bigdata.analysis.alignment.Bam2AvroMR;
import org.opencb.hpg.bigdata.analysis.alignment.stats.ReadAlignmentStatsMR;
import org.opencb.hpg.bigdata.analysis.io.parquet.ParquetMR;
import org.opencb.hpg.bigdata.app.cli.CommandExecutor;
import org.opencb.hpg.bigdata.app.cli.hadoop.CliOptionsParser;

public class AlignmentCommandExecutor
extends CommandExecutor {
    private CliOptionsParser.AlignmentCommandOptions alignmentCommandOptions;

    public AlignmentCommandExecutor(CliOptionsParser.AlignmentCommandOptions alignmentCommandOptions) {
        this.alignmentCommandOptions = alignmentCommandOptions;
    }

    @Override
    public void execute() throws Exception {
        String subCommand;
        switch (subCommand = this.alignmentCommandOptions.getParsedSubCommand()) {
            case "convert": {
                this.init(this.alignmentCommandOptions.convertAlignmentCommandOptions.commonOptions.logLevel, this.alignmentCommandOptions.convertAlignmentCommandOptions.commonOptions.verbose, this.alignmentCommandOptions.convertAlignmentCommandOptions.commonOptions.conf);
                this.convert();
                break;
            }
            case "stats": {
                this.init(this.alignmentCommandOptions.statsAlignmentCommandOptions.commonOptions.logLevel, this.alignmentCommandOptions.statsAlignmentCommandOptions.commonOptions.verbose, this.alignmentCommandOptions.statsAlignmentCommandOptions.commonOptions.conf);
                this.stats();
                break;
            }
            case "depth": {
                this.depth();
                break;
            }
            case "align": {
                System.out.println("Sub-command 'align': Not yet implemented for the command 'alignment' !");
                break;
            }
        }
    }

    private void convert() throws Exception {
        String input = this.alignmentCommandOptions.convertAlignmentCommandOptions.input;
        String output = this.alignmentCommandOptions.convertAlignmentCommandOptions.output;
        String compressionCodecName = this.alignmentCommandOptions.convertAlignmentCommandOptions.compression;
        if (compressionCodecName.equals("null")) {
            compressionCodecName = null;
        }
        Bam2AvroMR.run((String)input, (String)output, (String)compressionCodecName, (boolean)this.alignmentCommandOptions.convertAlignmentCommandOptions.adjustQuality);
        if (this.alignmentCommandOptions.convertAlignmentCommandOptions.toParquet) {
            new ParquetMR(ReadAlignment.getClassSchema()).run(output, output + ".parquet", compressionCodecName);
        }
    }

    private void stats() throws Exception {
        String input = this.alignmentCommandOptions.statsAlignmentCommandOptions.input;
        String output = this.alignmentCommandOptions.statsAlignmentCommandOptions.output;
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        String outHdfsDirname = Long.toString(new Date().getTime());
        ReadAlignmentStatsMR.run((String)input, (String)outHdfsDirname);
        Path outFile = new Path(outHdfsDirname + "/part-r-00000");
        if (!fs.exists(outFile)) {
            this.logger.error("Stats results file not found: {}", (Object)outFile.getName());
        } else {
            String outRawFileName = output + "/stats.json";
            fs.copyToLocalFile(outFile, new Path(outRawFileName));
        }
        fs.delete(new Path(outHdfsDirname), true);
    }

    private void depth() throws Exception {
        String input = this.alignmentCommandOptions.depthAlignmentCommandOptions.input;
        String output = this.alignmentCommandOptions.depthAlignmentCommandOptions.output;
        String regions = this.alignmentCommandOptions.depthAlignmentCommandOptions.regions;
        int minMapQ = this.alignmentCommandOptions.depthAlignmentCommandOptions.minMapQ;
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
    }
}

