/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.app.cli;

import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommandExecutor {
    protected String logLevel;
    protected boolean verbose;
    protected String configFile;
    protected String appHome;
    protected Logger logger;

    public CommandExecutor() {
    }

    public CommandExecutor(String logLevel) {
        this(logLevel, false, null);
    }

    public CommandExecutor(String logLevel, boolean verbose, String configFile) {
        this.logLevel = logLevel;
        this.verbose = verbose;
        this.configFile = configFile;
        this.appHome = System.getProperty("app.home", "/opt/hpg-bigdata");
        if (logLevel == null || logLevel.isEmpty()) {
            logLevel = "info";
        }
        this.setLogLevel(logLevel);
    }

    protected void init(String logLevel, boolean verbose, String configFile) {
        this.logLevel = logLevel;
        this.verbose = verbose;
        this.configFile = configFile;
        this.appHome = System.getProperty("app.home", "/opt/hpg-bigdata");
        if (logLevel == null || logLevel.isEmpty()) {
            logLevel = "info";
        }
        this.setLogLevel(logLevel);
    }

    public abstract void execute() throws Exception;

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        LogManager.getRootLogger().setLevel(Level.toLevel((String)logLevel));
        this.logger = LoggerFactory.getLogger((String)this.getClass().toString());
        this.logLevel = logLevel;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

