/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.app;

import com.beust.jcommander.ParameterException;
import java.io.IOException;
import java.util.Properties;
import org.opencb.hpg.bigdata.app.cli.CommandExecutor;
import org.opencb.hpg.bigdata.app.cli.hadoop.AlignmentCommandExecutor;
import org.opencb.hpg.bigdata.app.cli.hadoop.CliOptionsParser;
import org.opencb.hpg.bigdata.app.cli.hadoop.SequenceCommandExecutor;
import org.opencb.hpg.bigdata.app.cli.hadoop.VariantCommandExecutor;

public class BigDataMain {
    public static void main(String[] args) {
        CliOptionsParser cliOptionsParser = new CliOptionsParser();
        if (args == null || args.length == 0) {
            cliOptionsParser.printUsage();
        }
        try {
            cliOptionsParser.parse(args);
        }
        catch (ParameterException e) {
            System.out.println(e.getMessage());
            cliOptionsParser.printUsage();
            System.exit(-1);
        }
        String parsedCommand = cliOptionsParser.getCommand();
        if (parsedCommand == null || parsedCommand.isEmpty()) {
            if (cliOptionsParser.getGeneralOptions().help) {
                cliOptionsParser.printUsage();
                System.exit(0);
            }
            if (cliOptionsParser.getGeneralOptions().version) {
                BigDataMain.printVersion();
            }
        } else {
            CommandExecutor commandExecutor = null;
            if (cliOptionsParser.getCommandOptions().help || cliOptionsParser.getCommonCommandOptions().help) {
                cliOptionsParser.printUsage();
            } else {
                String parsedSubCommand = cliOptionsParser.getSubCommand();
                if (parsedSubCommand == null || parsedSubCommand.isEmpty()) {
                    cliOptionsParser.printUsage();
                } else {
                    switch (parsedCommand) {
                        case "sequence": {
                            commandExecutor = new SequenceCommandExecutor(cliOptionsParser.getSequenceCommandOptions());
                            break;
                        }
                        case "alignment": {
                            commandExecutor = new AlignmentCommandExecutor(cliOptionsParser.getAlignmentCommandOptions());
                            break;
                        }
                        case "variant": {
                            commandExecutor = new VariantCommandExecutor(cliOptionsParser.getVariantCommandOptions());
                            break;
                        }
                        case "feature": {
                            System.out.printf("Not yet implemented: not valid command: '" + parsedCommand + "'", new Object[0]);
                            break;
                        }
                        default: {
                            System.out.printf("ERROR: not valid command: '" + parsedCommand + "'", new Object[0]);
                            cliOptionsParser.printUsage();
                        }
                    }
                }
            }
            if (commandExecutor != null) {
                try {
                    commandExecutor.execute();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        }
    }

    public static void printVersion() {
        Properties properties = new Properties();
        try {
            properties.load(BigDataMain.class.getClassLoader().getResourceAsStream("conf.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String version = properties.getProperty("HPG.BIGDATA.VERSION", "<unkwnown>");
        System.out.println("HPG BigData v" + version);
        System.out.println("");
        System.out.println("Read more on https://github.com/opencb/hpg-bigdata");
    }
}

