/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.app;

import com.beust.jcommander.ParameterException;
import org.opencb.hpg.bigdata.app.cli.CommandExecutor;
import org.opencb.hpg.bigdata.app.cli.local.AdminCommandExecutor;
import org.opencb.hpg.bigdata.app.cli.local.AlignmentCommandExecutor;
import org.opencb.hpg.bigdata.app.cli.local.LocalCliOptionsParser;
import org.opencb.hpg.bigdata.app.cli.local.SequenceCommandExecutor;
import org.opencb.hpg.bigdata.app.cli.local.VariantCommandExecutor;

public class BigDataLocalMain {
    public static void main(String[] args) {
        LocalCliOptionsParser localCliOptionsParser = new LocalCliOptionsParser();
        if (args == null || args.length == 0) {
            localCliOptionsParser.printUsage();
        }
        try {
            localCliOptionsParser.parse(args);
        }
        catch (ParameterException e) {
            System.out.println(e.getMessage());
            localCliOptionsParser.printUsage();
            System.exit(-1);
        }
        String parsedCommand = localCliOptionsParser.getCommand();
        if (parsedCommand == null || parsedCommand.isEmpty()) {
            if (localCliOptionsParser.getGeneralOptions().help) {
                localCliOptionsParser.printUsage();
                System.exit(0);
            }
            if (localCliOptionsParser.getGeneralOptions().version) {
                localCliOptionsParser.printUsage();
            }
        } else {
            CommandExecutor commandExecutor = null;
            if (localCliOptionsParser.getCommandOptions().help || localCliOptionsParser.getCommonCommandOptions().help) {
                localCliOptionsParser.printUsage();
            } else {
                String parsedSubCommand = localCliOptionsParser.getSubCommand();
                if (parsedSubCommand == null || parsedSubCommand.isEmpty()) {
                    localCliOptionsParser.printUsage();
                } else {
                    switch (parsedCommand) {
                        case "admin": {
                            commandExecutor = new AdminCommandExecutor(localCliOptionsParser.getAdminCommandOptions());
                            break;
                        }
                        case "sequence": {
                            commandExecutor = new SequenceCommandExecutor(localCliOptionsParser.getSequenceCommandOptions());
                            break;
                        }
                        case "alignment": {
                            commandExecutor = new AlignmentCommandExecutor(localCliOptionsParser.getAlignmentCommandOptions());
                            break;
                        }
                        case "variant": {
                            commandExecutor = new VariantCommandExecutor(localCliOptionsParser.getVariantCommandOptions());
                            break;
                        }
                        default: {
                            System.out.printf("ERROR: not valid command: '" + parsedCommand + "'", new Object[0]);
                            localCliOptionsParser.printUsage();
                        }
                    }
                    if (commandExecutor != null) {
                        try {
                            commandExecutor.execute();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.exit(1);
                        }
                    }
                }
            }
        }
    }
}

