/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.analysis.variant.wrappers;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.opencb.commons.datastore.core.Query;
import org.opencb.hpg.bigdata.analysis.exceptions.AnalysisExecutorException;
import org.opencb.hpg.bigdata.analysis.exceptions.AnalysisToolException;
import org.opencb.hpg.bigdata.analysis.tools.Executor;
import org.opencb.hpg.bigdata.analysis.variant.VariantAnalysisUtils;
import org.opencb.hpg.bigdata.analysis.variant.wrappers.VariantAnalysisWrapper;
import org.opencb.hpg.bigdata.core.config.AnalysisConfiguration;
import org.opencb.hpg.bigdata.core.config.OskarConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RvTestsWrapper
extends VariantAnalysisWrapper {
    public static final String ANALYSIS_NAME = "rvtests";
    private String inFilename;
    private String metaFilename;
    private Query query;
    private Map<String, String> rvtestsParams;
    private Logger logger;

    public RvTestsWrapper(String studyId, String inFilename, String metaFilename, Query query, Map<String, String> rvtestsParams, OskarConfiguration configuration) {
        super(studyId, configuration);
        this.inFilename = inFilename;
        this.metaFilename = metaFilename;
        this.query = query;
        this.rvtestsParams = rvtestsParams;
        this.logger = LoggerFactory.getLogger(RvTestsWrapper.class);
    }

    @Override
    public void execute() throws AnalysisExecutorException {
        Path binPath;
        try {
            binPath = Paths.get(((AnalysisConfiguration.Analysis)this.configuration.getAnalysis().get((Object)ANALYSIS_NAME)).getPath(), new String[0]);
            if (binPath == null || !binPath.toFile().exists()) {
                String msg = "RvTests binary path is missing or does not exist:  '" + binPath + "'.";
                this.logger.error(msg);
                throw new AnalysisExecutorException(msg);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new AnalysisExecutorException(e.getMessage());
        }
        Path outDir = Paths.get("/tmp", new String[0]);
        if (this.rvtestsParams.get("out") != null) {
            outDir = Paths.get(this.rvtestsParams.get("out"), new String[0]).getParent();
        }
        String vcfFilename = outDir.toString() + "/tmp.vcf";
        VariantAnalysisUtils.exportVCF(this.inFilename, this.metaFilename, this.query, vcfFilename);
        String pedFilename = outDir.toString() + "/tmp.vcf.ped";
        try {
            VariantAnalysisUtils.exportPedigree(this.metaFilename, this.studyId, pedFilename);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            throw new AnalysisExecutorException(e);
        }
        StringBuilder sb = new StringBuilder();
        sb.setLength(0);
        sb.append(binPath);
        sb.append(" --inVcf ").append(vcfFilename);
        sb.append(" --pheno ").append(pedFilename);
        for (String key : this.rvtestsParams.keySet()) {
            sb.append(" --").append(key).append(" ").append(this.rvtestsParams.get(key));
        }
        try {
            Executor.execute(sb.toString(), outDir, true);
        }
        catch (AnalysisToolException e) {
            this.logger.error(e.getMessage());
            throw new AnalysisExecutorException(e);
        }
    }
}

