/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.analysis.variant.wrappers;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.spark.sql.SparkSession;
import org.opencb.biodata.models.core.pedigree.Individual;
import org.opencb.biodata.models.metadata.Individual;
import org.opencb.biodata.models.metadata.Sample;
import org.opencb.biodata.models.variant.StudyEntry;
import org.opencb.biodata.models.variant.Variant;
import org.opencb.biodata.models.variant.metadata.VariantStudyMetadata;
import org.opencb.biodata.tools.variant.metadata.VariantMetadataManager;
import org.opencb.biodata.tools.variant.metadata.VariantMetadataUtils;
import org.opencb.commons.datastore.core.Query;
import org.opencb.hpg.bigdata.analysis.exceptions.AnalysisExecutorException;
import org.opencb.hpg.bigdata.analysis.exceptions.AnalysisToolException;
import org.opencb.hpg.bigdata.analysis.tools.Executor;
import org.opencb.hpg.bigdata.analysis.variant.wrappers.VariantAnalysisWrapper;
import org.opencb.hpg.bigdata.core.config.AnalysisConfiguration;
import org.opencb.hpg.bigdata.core.config.OskarConfiguration;
import org.opencb.hpg.bigdata.core.lib.VariantDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlinkWrapper
extends VariantAnalysisWrapper {
    public static final String ANALYSIS_NAME = "plink";
    private String inFilename;
    private String metaFilename;
    private Query query;
    private Map<String, String> plinkParams;
    private Logger logger;

    public PlinkWrapper(String studyId, String inFilename, String metaFilename, Query query, Map<String, String> plinkParams, OskarConfiguration configuration) {
        super(studyId, configuration);
        this.inFilename = inFilename;
        this.metaFilename = metaFilename;
        this.query = query;
        this.plinkParams = plinkParams;
        this.logger = LoggerFactory.getLogger(PlinkWrapper.class);
    }

    @Override
    public void execute() throws AnalysisExecutorException {
        Path binPath;
        try {
            binPath = Paths.get(((AnalysisConfiguration.Analysis)this.configuration.getAnalysis().get((Object)ANALYSIS_NAME)).getPath(), new String[0]);
            if (binPath == null || !binPath.toFile().exists()) {
                String msg = "PLINK binary path is missing or does not exist:  '" + binPath + "'.";
                this.logger.error(msg);
                throw new AnalysisExecutorException(msg);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new AnalysisExecutorException(e.getMessage());
        }
        Path outDir = Paths.get("/tmp", new String[0]);
        if (this.plinkParams.get("out") != null) {
            outDir = Paths.get(this.plinkParams.get("out"), new String[0]).getParent();
        }
        VariantMetadataManager manager = new VariantMetadataManager();
        try {
            manager.load(Paths.get(this.metaFilename, new String[0]));
            SparkSession sparkSession = SparkSession.builder().appName("variant-plink").getOrCreate();
            VariantDataset vd = new VariantDataset(sparkSession);
            vd.load(this.inFilename);
            vd.createOrReplaceTempView("vcf");
            if (this.query != null) {
                vd.setQuery(this.query);
            }
            VariantStudyMetadata studyMetadata = (VariantStudyMetadata)manager.getVariantMetadata().getStudies().get(0);
            this.exportPedMapFile(vd, studyMetadata, outDir + "/plink");
            sparkSession.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Error executing PLINK tool when retrieving variants to PED and MAP files: {}", (Object)e.getMessage());
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(binPath);
        sb.append(" --file ").append(outDir).append("/plink");
        for (String key : this.plinkParams.keySet()) {
            sb.append(" --").append(key);
            String value = this.plinkParams.get(key);
            if (StringUtils.isEmpty((String)value)) continue;
            sb.append(" ").append(value);
        }
        try {
            Executor.execute(sb.toString(), outDir, true);
        }
        catch (AnalysisToolException e) {
            this.logger.error(e.getMessage());
            throw new AnalysisExecutorException(e);
        }
    }

    public void exportPedMapFile(VariantDataset variantDataset, VariantStudyMetadata studyMetadata, String prefix) throws FileNotFoundException {
        Path pedPath = Paths.get(prefix + ".ped", new String[0]);
        Path mapPath = Paths.get(prefix + ".map", new String[0]);
        StringBuilder sb = new StringBuilder();
        PrintWriter pedWriter = new PrintWriter(pedPath.toFile());
        PrintWriter mapWriter = new PrintWriter(mapPath.toFile());
        Iterator iterator = variantDataset.iterator();
        List sampleNames = VariantMetadataUtils.getSampleNames((VariantStudyMetadata)studyMetadata);
        StringBuilder[] markers = new StringBuilder[sampleNames.size()];
        while (iterator.hasNext()) {
            Variant variant = (Variant)iterator.next();
            List sampleData = ((StudyEntry)variant.getStudiesMap().get(studyMetadata.getId())).getSamplesData();
            assert (sampleData.size() == sampleNames.size());
            for (int i = 0; i < sampleData.size(); ++i) {
                String[] gt = ((String)((List)sampleData.get(i)).get(0)).split("[|/]");
                if (markers[i] == null) {
                    markers[i] = new StringBuilder();
                }
                markers[i].append("\t" + (gt[0].equals("1") ? variant.getAlternate() : variant.getReference()) + "\t" + (gt[1].equals("1") ? variant.getAlternate() : variant.getReference()));
            }
            mapWriter.println(variant.getChromosome() + "\t" + variant.getId() + "\t0\t" + variant.getStart());
        }
        for (int i = 0; i < sampleNames.size(); ++i) {
            sb.setLength(0);
            String sampleName = (String)sampleNames.get(i);
            Individual individual = this.getIndividualBySampleName(sampleName, studyMetadata);
            if (individual == null) {
                sb.append(0).append("\t");
                sb.append(sampleName).append("\t");
                sb.append(0).append("\t");
                sb.append(0).append("\t");
                sb.append(0).append("\t");
                sb.append(0);
            } else {
                int sex = Individual.Sex.getEnum((String)individual.getSex()).getValue();
                int phenotype = Individual.AffectionStatus.getEnum((String)individual.getPhenotype()).getValue();
                sb.append(individual.getFamily() == null ? Integer.valueOf(0) : individual.getFamily()).append("\t");
                sb.append(sampleName).append("\t");
                sb.append(individual.getFather() == null ? Integer.valueOf(0) : individual.getFather()).append("\t");
                sb.append(individual.getMother() == null ? Integer.valueOf(0) : individual.getMother()).append("\t");
                sb.append(sex).append("\t");
                sb.append(phenotype);
            }
            sb.append((CharSequence)markers[i]);
            pedWriter.println(sb.toString());
        }
        pedWriter.close();
        mapWriter.close();
    }

    private Individual getIndividualBySampleName(String sampleName, VariantStudyMetadata studyMetadata) {
        for (Individual individual : studyMetadata.getIndividuals()) {
            for (Sample sample : individual.getSamples()) {
                if (!sampleName.equals(sample.getId())) continue;
                return individual;
            }
        }
        return null;
    }
}

