/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.analysis.variant.statistics;

public class StatsUtils {
    public static double[] cummin(int[] data) {
        return StatsUtils.cummin(StatsUtils.toDoubleArray(data));
    }

    public static double[] cummin(double[] data) {
        double[] res = new double[data.length];
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < data.length; ++i) {
            min = Double.isNaN(data[i]) || Double.isNaN(min) ? (min += data[i]) : (min < data[i] ? min : data[i]);
            res[i] = min;
        }
        return res;
    }

    public static double[] cummax(int[] data) {
        return StatsUtils.cummax(StatsUtils.toDoubleArray(data));
    }

    public static double[] cummax(double[] data) {
        double[] res = new double[data.length];
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < data.length; ++i) {
            max = Double.isNaN(data[i]) || Double.isNaN(max) ? (max += data[i]) : (max > data[i] ? max : data[i]);
            res[i] = max;
        }
        return res;
    }

    public static double[] cumsum(double[] data) {
        double[] res = new double[data.length];
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            res[i] = sum += data[i];
        }
        return res;
    }

    public static double[] pmin(double min, double[] data) {
        double[] res = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            res[i] = min < data[i] ? min : data[i];
        }
        return res;
    }

    public static double[] pmax(double max, double[] data) {
        double[] res = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            res[i] = max > data[i] ? max : data[i];
        }
        return res;
    }

    public static double[] toDoubleArray(int[] data) {
        double[] res = null;
        if (data != null) {
            res = new double[data.length];
            for (int i = 0; i < data.length; ++i) {
                res[i] = data[i];
            }
        }
        return res;
    }

    public static int[] order(int[] data) {
        return StatsUtils.order(StatsUtils.toDoubleArray(data), false);
    }

    public static int[] order(double[] data) {
        return StatsUtils.order(data, false);
    }

    public static int[] order(double[] data, boolean decreasing) {
        int[] order = new int[data.length];
        double[] clonedData = (double[])data.clone();
        if (decreasing) {
            int i;
            double min = StatsUtils.nonInfinityAndMinValueMin(clonedData);
            for (i = 0; i < clonedData.length; ++i) {
                if (Double.isNaN(clonedData[i])) {
                    clonedData[i] = min - 3.0;
                }
                if (clonedData[i] == Double.NEGATIVE_INFINITY) {
                    clonedData[i] = min - 2.0;
                }
                if (clonedData[i] != Double.MIN_VALUE) continue;
                clonedData[i] = min - 1.0;
            }
            for (i = 0; i < clonedData.length; ++i) {
                order[i] = StatsUtils.maxIndex(clonedData);
                clonedData[order[i]] = Double.NEGATIVE_INFINITY;
            }
        } else {
            int i;
            double max = StatsUtils.nonInfinityAndMaxValueMax(clonedData);
            for (i = 0; i < clonedData.length; ++i) {
                if (Double.isNaN(clonedData[i])) {
                    clonedData[i] = max + 3.0;
                }
                if (clonedData[i] == Double.POSITIVE_INFINITY) {
                    clonedData[i] = max + 2.0;
                }
                if (clonedData[i] != Double.MAX_VALUE) continue;
                clonedData[i] = max + 1.0;
            }
            for (i = 0; i < clonedData.length; ++i) {
                order[i] = StatsUtils.minIndex(clonedData);
                clonedData[order[i]] = Double.POSITIVE_INFINITY;
            }
        }
        return order;
    }

    public static int minIndex(double[] values) {
        return StatsUtils.minIndex(values, 0, values.length);
    }

    public static int minIndex(double[] values, int begin, int end) {
        double min = Double.NaN;
        int index = -1;
        min = values[begin];
        index = begin;
        for (int i = begin; i < end; ++i) {
            if (Double.isNaN(values[i]) || !(values[i] < min)) continue;
            min = values[i];
            index = i;
        }
        return index;
    }

    public static int maxIndex(double[] values) {
        return StatsUtils.maxIndex(values, 0, values.length);
    }

    public static int maxIndex(double[] values, int begin, int end) {
        double max = Double.NaN;
        int index = -1;
        max = values[begin];
        index = begin;
        for (int i = begin; i < end; ++i) {
            if (Double.isNaN(values[i]) || !(values[i] > max)) continue;
            max = values[i];
            index = i;
        }
        return index;
    }

    public static double nonInfinityAndMinValueMin(double[] data) {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] < min) || data[i] == Double.NEGATIVE_INFINITY || data[i] == Double.MIN_VALUE) continue;
            min = data[i];
        }
        return min;
    }

    public static double nonInfinityAndMaxValueMax(double[] data) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] > max) || data[i] == Double.POSITIVE_INFINITY || data[i] == Double.MAX_VALUE) continue;
            max = data[i];
        }
        return max;
    }

    public static double[] ordered(double[] data, int[] pos) {
        double[] ordered = null;
        if (data.length == pos.length) {
            ordered = new double[data.length];
            for (int i = 0; i < pos.length; ++i) {
                ordered[i] = data[pos[i]];
            }
        }
        return ordered;
    }
}

