/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.analysis.variant.statistics;

import java.security.InvalidParameterException;
import org.opencb.hpg.bigdata.analysis.variant.statistics.StatsUtils;

public class MultipleTestCorrection {
    public static double[] fdrCorrection(double[] pvalues) throws InvalidParameterException {
        return MultipleTestCorrection.bHCorrection(pvalues);
    }

    public static double[] bonferroniCorrection(double[] pvalues) throws InvalidParameterException {
        double[] res = new double[pvalues.length];
        int size = pvalues.length;
        for (int i = 0; i < size; ++i) {
            res[i] = pvalues[i] * (double)size;
        }
        return StatsUtils.pmin(1.0, res);
    }

    public static double[] bHCorrection(double[] pvalues) throws InvalidParameterException {
        int[] o = StatsUtils.order(pvalues, true);
        int[] ro = StatsUtils.order(o);
        double[] mult = StatsUtils.ordered(pvalues, o);
        int j = 0;
        for (int i = mult.length; i > 0; --i) {
            int n = j++;
            mult[n] = mult[n] * ((double)mult.length / (double)i);
        }
        return StatsUtils.ordered(StatsUtils.pmin(1.0, StatsUtils.cummin(mult)), ro);
    }

    public static double[] hochbergCorrection(double[] pvalues) throws InvalidParameterException {
        int[] o = StatsUtils.order(pvalues, true);
        int[] ro = StatsUtils.order(o);
        double[] mult = StatsUtils.ordered(pvalues, o);
        int j = 0;
        for (int i = mult.length; i > 0; --i) {
            int n = j++;
            mult[n] = mult[n] * (double)(mult.length - i + 1);
        }
        return StatsUtils.ordered(StatsUtils.pmin(1.0, StatsUtils.cummin(mult)), ro);
    }

    public static double[] bYCorrection(double[] pvalues) throws InvalidParameterException {
        int i;
        int[] o = StatsUtils.order(pvalues, true);
        int[] ro = StatsUtils.order(o);
        double[] mult = StatsUtils.ordered(pvalues, o);
        double q = 0.0;
        for (i = 1; i <= mult.length; ++i) {
            q += 1.0 / (double)i;
        }
        int j = 0;
        for (i = mult.length; i > 0; --i) {
            int n = j++;
            mult[n] = mult[n] * (q * (double)mult.length / (double)i);
        }
        return StatsUtils.ordered(StatsUtils.pmin(1.0, StatsUtils.cummin(mult)), ro);
    }

    public static double[] holmCorrection(double[] pvalues) throws InvalidParameterException {
        int[] o = StatsUtils.order(pvalues);
        int[] ro = StatsUtils.order(o);
        double[] mult = StatsUtils.ordered(pvalues, o);
        for (int i = 0; i < mult.length; ++i) {
            int n = i;
            mult[n] = mult[n] * (double)(mult.length - i);
        }
        return StatsUtils.ordered(StatsUtils.pmin(1.0, StatsUtils.cummax(mult)), ro);
    }
}

