/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.analysis.variant.statistics;

import java.security.InvalidParameterException;
import org.opencb.hpg.bigdata.analysis.variant.statistics.FisherTestResult;

public class FisherExactTest {
    public static final int LESS = 1;
    public static final int GREATER = 2;
    public static final int TWO_SIDED = 3;
    private double[] factorialLogarithms;

    private void initLogarithmArray(int nmax) {
        this.factorialLogarithms = new double[nmax];
        this.factorialLogarithms[0] = 0.0;
        this.factorialLogarithms[1] = 0.0;
        for (int i = 2; i < nmax; ++i) {
            this.factorialLogarithms[i] = this.factorialLogarithms[i - 1] + Math.log(i);
        }
    }

    public FisherTestResult fisherTest(int a, int b, int c, int d) {
        return this.fisherTest(a, b, c, d, 3);
    }

    public FisherTestResult fisherTest(int[] values) throws InvalidParameterException {
        if (values == null || values.length != 4) {
            throw new InvalidParameterException("The matrix must have 4 columns (a, b, c and d)");
        }
        return this.fisherTest(values[0], values[1], values[2], values[3]);
    }

    public FisherTestResult fisherTest(int a, int b, int c, int d, int mode) {
        this.initLogarithmArray(a + b + c + d + 1);
        return new FisherTestResult(this.computeFisherTest(a, b, c, d, mode), this.computeOddRatio(a, b, c, d));
    }

    private double computeFisherTest(int a, int b, int c, int d, int mode) {
        double result;
        int iniA = 0;
        int iniB = 0;
        int iniC = 0;
        int iniD = 0;
        int steps = 0;
        switch (mode) {
            case 1: {
                if (a > d) {
                    iniA = a - d;
                    iniB = b + d;
                    iniC = c + d;
                    iniD = 0;
                    steps = d;
                    break;
                }
                iniA = 0;
                iniB = b + a;
                iniC = c + a;
                iniD = d - a;
                steps = a;
                break;
            }
            case 2: {
                iniA = a;
                iniB = b;
                iniC = c;
                iniD = d;
                if (b > c) {
                    steps = c;
                    break;
                }
                steps = b;
                break;
            }
            case 3: {
                if (a > d) {
                    iniA = a - d;
                    iniB = b + d;
                    iniC = c + d;
                    iniD = 0;
                    steps = d;
                } else {
                    iniA = 0;
                    iniB = b + a;
                    iniC = c + a;
                    iniD = d - a;
                    steps = a;
                }
                if (b > c) {
                    steps += c;
                    break;
                }
                steps += b;
                break;
            }
        }
        double n = this.factorialLogarithms[a + b + c + d];
        double num = this.factorialLogarithms[iniA + iniB] + this.factorialLogarithms[iniB + iniD] + this.factorialLogarithms[iniA + iniC] + this.factorialLogarithms[iniC + iniD];
        double den = n + this.factorialLogarithms[iniA] + this.factorialLogarithms[iniB] + this.factorialLogarithms[iniC] + this.factorialLogarithms[iniD];
        double pAct = num - den;
        if (mode == 3) {
            num = this.factorialLogarithms[a + b] + this.factorialLogarithms[b + d] + this.factorialLogarithms[a + c] + this.factorialLogarithms[c + d];
            den = n + this.factorialLogarithms[a] + this.factorialLogarithms[b] + this.factorialLogarithms[c] + this.factorialLogarithms[d];
            double pIni = num - den;
            result = pAct <= pIni ? Math.exp(pAct) : 0.0;
            while (steps-- > 0) {
                if (!((pAct = (num = this.factorialLogarithms[++iniA + --iniB] + this.factorialLogarithms[iniB + ++iniD] + this.factorialLogarithms[iniA + --iniC] + this.factorialLogarithms[iniC + iniD]) - (den = n + this.factorialLogarithms[iniA] + this.factorialLogarithms[iniB] + this.factorialLogarithms[iniC] + this.factorialLogarithms[iniD])) <= pIni)) continue;
                result += Math.exp(pAct);
            }
        } else {
            result = Math.exp(pAct);
            while (steps-- > 0) {
                num = this.factorialLogarithms[++iniA + --iniB] + this.factorialLogarithms[iniB + ++iniD] + this.factorialLogarithms[iniA + --iniC] + this.factorialLogarithms[iniC + iniD];
                den = n + this.factorialLogarithms[iniA] + this.factorialLogarithms[iniB] + this.factorialLogarithms[iniC] + this.factorialLogarithms[iniD];
                pAct = num - den;
                result += Math.exp(pAct);
            }
        }
        return result;
    }

    private double computeOddRatio(int a, int b, int c, int d) {
        return (double)(a * d) / (double)(b * c);
    }
}

