/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.analysis.variant;

import htsjdk.variant.variantcontext.writer.Options;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import org.apache.spark.sql.SparkSession;
import org.opencb.biodata.formats.pedigree.PedigreeManager;
import org.opencb.biodata.models.variant.metadata.VariantStudyMetadata;
import org.opencb.biodata.tools.variant.converters.VCFExporter;
import org.opencb.biodata.tools.variant.metadata.VariantMetadataManager;
import org.opencb.commons.datastore.core.Query;
import org.opencb.hpg.bigdata.core.lib.VariantDataset;

public class VariantAnalysisUtils {
    public static void exportVCF(String inputAvroFilename, String metaFilename, Query query, String vcfFilename) {
        VariantMetadataManager manager = new VariantMetadataManager();
        try {
            manager.load(Paths.get(metaFilename, new String[0]));
            SparkSession sparkSession = SparkSession.builder().appName("vcf-exporter").getOrCreate();
            VariantDataset vd = new VariantDataset(sparkSession);
            vd.load(inputAvroFilename);
            vd.createOrReplaceTempView("vcf");
            if (query != null) {
                vd.setQuery(query);
            }
            VariantStudyMetadata studyMetadata = (VariantStudyMetadata)manager.getVariantMetadata().getStudies().get(0);
            VCFExporter vcfExporter = new VCFExporter(studyMetadata);
            vcfExporter.open(Paths.get(vcfFilename, new String[0]), new Options[0]);
            vcfExporter.export(vd.iterator());
            vcfExporter.close();
            sparkSession.stop();
        }
        catch (Exception e) {
            System.out.println("Error retrieving variants from Avro/Parquet to VCF file: " + e.getMessage());
        }
    }

    public static void exportPedigree(String metaFilename, String studyId, String pedFilename) throws IOException {
        VariantMetadataManager metadataManager = new VariantMetadataManager();
        metadataManager.load(Paths.get(metaFilename, new String[0]));
        List pedigrees = metadataManager.getPedigree(studyId);
        PedigreeManager pedigreeManager = new PedigreeManager();
        pedigreeManager.save(pedigrees, Paths.get(pedFilename, new String[0]));
    }
}

