/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.analysis.variant;

import org.apache.spark.ml.feature.PCA;
import org.apache.spark.ml.feature.PCAModel;
import org.apache.spark.sql.Dataset;
import org.opencb.hpg.bigdata.analysis.variant.VariantAnalysisExecutor;
import org.opencb.hpg.bigdata.core.config.OskarConfiguration;

public class PCAAnalysis
extends VariantAnalysisExecutor {
    private int kValue = 3;
    private String featureName;

    @Override
    public void execute() {
        Dataset dataset = null;
        PCAModel pca = new PCA().setInputCol(this.featureName).setOutputCol("pca").setK(this.kValue).fit(dataset);
        Dataset result = pca.transform(dataset).select("pca", new String[0]);
        result.show(false);
    }

    public PCAAnalysis(String studyId, String studyName, String featureName, OskarConfiguration configuration) {
        this(studyId, studyName, featureName, 3, configuration);
    }

    public PCAAnalysis(String studyId, String studyName, String featureName, int kValue, OskarConfiguration configuration) {
        super(studyId, configuration);
        this.featureName = featureName;
        this.kValue = kValue;
    }

    public int getkValue() {
        return this.kValue;
    }

    public void setkValue(int kValue) {
        this.kValue = kValue;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }
}

