/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.analysis.variant;

import org.apache.spark.ml.classification.BinaryLogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions;
import org.opencb.hpg.bigdata.analysis.variant.VariantAnalysisExecutor;
import org.opencb.hpg.bigdata.core.config.OskarConfiguration;

public class LogisticRegressionAnalysis
extends VariantAnalysisExecutor {
    private String depVarName;
    private String indepVarName;
    private int numIterations = 10;
    private double regularization = 0.3;
    private double elasticNet = 0.8;

    @Override
    public void execute() {
        double[] objectiveHistory;
        LogisticRegression lr = new LogisticRegression().setMaxIter(this.numIterations).setRegParam(this.regularization).setElasticNetParam(this.elasticNet);
        Dataset training = null;
        LogisticRegressionModel lrModel = (LogisticRegressionModel)lr.fit(training);
        System.out.println("Coefficients: " + lrModel.coefficients() + " Intercept: " + lrModel.intercept());
        LogisticRegressionTrainingSummary trainingSummary = lrModel.summary();
        System.out.println("numIterations: " + trainingSummary.totalIterations());
        System.out.println("objectiveHistory: " + Vectors.dense((double[])trainingSummary.objectiveHistory()));
        for (double lossPerIteration : objectiveHistory = trainingSummary.objectiveHistory()) {
            System.out.println(lossPerIteration);
        }
        BinaryLogisticRegressionSummary binarySummary = (BinaryLogisticRegressionSummary)trainingSummary;
        Dataset roc = binarySummary.roc();
        roc.show();
        roc.select("FPR", new String[0]).show();
        System.out.println(binarySummary.areaUnderROC());
        Dataset fMeasure = binarySummary.fMeasureByThreshold();
        double maxFMeasure = ((Row)fMeasure.select(new Column[]{functions.max((String)"F-Measure")}).head()).getDouble(0);
        double bestThreshold = ((Row)fMeasure.where(fMeasure.col("F-Measure").equalTo((Object)maxFMeasure)).select("threshold", new String[0]).head()).getDouble(0);
        lrModel.setThreshold(bestThreshold);
    }

    public LogisticRegressionAnalysis(String studyId, String depVarName, String indepVarName, OskarConfiguration configuration) {
        this(studyId, depVarName, indepVarName, 10, 0.3, 0.8, configuration);
    }

    public LogisticRegressionAnalysis(String studyId, String depVarName, String indepVarName, int numIterations, double regularization, double elasticNet, OskarConfiguration configuration) {
        super(studyId, configuration);
        this.depVarName = depVarName;
        this.indepVarName = indepVarName;
        this.numIterations = numIterations;
        this.regularization = regularization;
        this.elasticNet = elasticNet;
    }

    public String getDepVarName() {
        return this.depVarName;
    }

    public void setDepVarName(String depVarName) {
        this.depVarName = depVarName;
    }

    public String getIndepVarName() {
        return this.indepVarName;
    }

    public void setIndepVarName(String indepVarName) {
        this.indepVarName = indepVarName;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }

    public double getRegularization() {
        return this.regularization;
    }

    public void setRegularization(double regularization) {
        this.regularization = regularization;
    }

    public double getElasticNet() {
        return this.elasticNet;
    }

    public void setElasticNet(double elasticNet) {
        this.elasticNet = elasticNet;
    }
}

