/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.analysis.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;

public class ChunkKey
implements WritableComparable<ChunkKey> {
    private String name;
    private Integer chunk;

    public ChunkKey() {
    }

    public ChunkKey(String name, Integer chunk) {
        this.name = name;
        this.chunk = chunk;
    }

    public String toString() {
        return '{' + this.name + ',' + this.chunk + '}';
    }

    public void readFields(DataInput in) throws IOException {
        this.name = WritableUtils.readString((DataInput)in);
        this.chunk = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeString((DataOutput)out, (String)this.name);
        out.writeInt(this.chunk);
    }

    public int compareTo(ChunkKey o) {
        int result = this.name.compareTo(o.name);
        if (0 == result) {
            result = this.chunk.compareTo(o.chunk);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getChunk() {
        return this.chunk;
    }

    public void setPos(Integer chunk) {
        this.chunk = chunk;
    }
}

