/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.analysis.tools.manifest;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.opencb.hpg.bigdata.analysis.tools.manifest.Contact;
import org.opencb.hpg.bigdata.analysis.tools.manifest.Execution;
import org.opencb.hpg.bigdata.analysis.tools.manifest.Git;
import org.opencb.hpg.bigdata.analysis.tools.manifest.ProgrammingLanguage;
import org.opencb.hpg.bigdata.analysis.tools.manifest.Settings;

public class Manifest {
    private String id;
    private String name;
    private String version;
    private String description;
    private String website;
    private String publication;
    private Contact contact;
    private Git git;
    private ProgrammingLanguage language;
    private List<String> dependencies;
    private List<Execution> executions;
    private Settings settings;

    public void serialize(OutputStream configurationOututStream) throws IOException {
        ObjectMapper jsonMapper = new ObjectMapper();
        jsonMapper.writerWithDefaultPrettyPrinter().writeValue(configurationOututStream, (Object)this);
    }

    public static Manifest load(InputStream manifestStream) throws IOException {
        return Manifest.load(manifestStream, "json");
    }

    private static Manifest load(InputStream manifestStream, String format) throws IOException {
        Manifest manifest;
        switch (format) {
            case "json": {
                ObjectMapper objectMapper = new ObjectMapper();
                manifest = (Manifest)objectMapper.readValue(manifestStream, Manifest.class);
                break;
            }
            default: {
                ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                manifest = (Manifest)objectMapper.readValue(manifestStream, Manifest.class);
            }
        }
        return manifest;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Manifest{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", version='").append(this.version).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", website='").append(this.website).append('\'');
        sb.append(", publication='").append(this.publication).append('\'');
        sb.append(", contact=").append(this.contact);
        sb.append(", git=").append(this.git);
        sb.append(", language=").append(this.language);
        sb.append(", dependencies=").append(this.dependencies);
        sb.append(", executions=").append(this.executions);
        sb.append(", settings=").append(this.settings);
        sb.append('}');
        return sb.toString();
    }

    public Contact getContact() {
        return this.contact;
    }

    public Manifest setContact(Contact contact) {
        this.contact = contact;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Manifest setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Manifest setName(String name) {
        this.name = name;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public Manifest setVersion(String version) {
        this.version = version;
        return this;
    }

    public Git getGit() {
        return this.git;
    }

    public Manifest setGit(Git git) {
        this.git = git;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Manifest setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getWebsite() {
        return this.website;
    }

    public Manifest setWebsite(String website) {
        this.website = website;
        return this;
    }

    public String getPublication() {
        return this.publication;
    }

    public Manifest setPublication(String publication) {
        this.publication = publication;
        return this;
    }

    public ProgrammingLanguage getLanguage() {
        return this.language;
    }

    public Manifest setLanguage(ProgrammingLanguage language) {
        this.language = language;
        return this;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public Manifest setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public List<Execution> getExecutions() {
        return this.executions;
    }

    public Manifest setExecutions(List<Execution> executions) {
        this.executions = executions;
        return this;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Manifest setSettings(Settings settings) {
        this.settings = settings;
        return this;
    }
}

