/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.analysis.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opencb.hpg.bigdata.analysis.exceptions.AnalysisToolException;
import org.opencb.hpg.bigdata.analysis.tools.Executor;
import org.opencb.hpg.bigdata.analysis.tools.manifest.Execution;
import org.opencb.hpg.bigdata.analysis.tools.manifest.Manifest;
import org.opencb.hpg.bigdata.analysis.tools.manifest.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolManager {
    private Path toolDirectory;
    private Map<String, Manifest> tools;
    private Logger logger;
    private final String MANIFEST_FILE = "manifest.json";

    public ToolManager(Path toolDirectory) throws AnalysisToolException {
        this.toolDirectory = toolDirectory;
        this.tools = new HashMap<String, Manifest>();
        this.logger = LoggerFactory.getLogger(ToolManager.class);
        this.checkToolDirectory();
    }

    public String createCommandLine(String tool, String executionName, Map<String, String> paramsMap) throws AnalysisToolException {
        Manifest manifest = this.getManifest(tool);
        Execution execution = null;
        for (Execution executionTmp : manifest.getExecutions()) {
            if (!executionTmp.getId().equalsIgnoreCase(executionName)) continue;
            execution = executionTmp;
            break;
        }
        if (execution == null) {
            throw new AnalysisToolException("Execution " + executionName + " not found in manifest");
        }
        final Map<String, Param> manifestParams = execution.getParamsAsMap();
        this.validateParams(execution, paramsMap);
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int i = this.getPosition(o1).compareTo(this.getPosition(o2));
                if (i != 0) {
                    return i;
                }
                return o1.compareTo(o2);
            }

            private Integer getPosition(String o) {
                Param inputParam = (Param)manifestParams.get(o);
                return inputParam != null ? (inputParam.isRedirection() ? Integer.MAX_VALUE : inputParam.getPosition()) : 0;
            }
        };
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(comparator);
        sortedMap.putAll(paramsMap);
        String[] fields = execution.getBin().split(" ");
        StringBuilder commandLine = new StringBuilder("'").append(this.toolDirectory.resolve(tool).toString()).append("/").append(fields[0]).append("' ");
        for (int i = 1; i < fields.length; ++i) {
            commandLine.append(fields[i]).append(" ");
        }
        for (Map.Entry objectEntry : sortedMap.entrySet()) {
            String key;
            Param inputParam = manifestParams.get(objectEntry.getKey());
            if (inputParam != null) {
                if (!inputParam.isHidden() && !inputParam.isRedirection()) {
                    key = inputParam.getName();
                    if (!key.startsWith("-") && manifest.getSettings().isPosix()) {
                        key = (key.length() > 1 ? "--" : "-") + key;
                    }
                    commandLine.append(key).append(manifest.getSettings().getSeparator());
                }
                if (inputParam.getDataType() != Param.Type.BOOLEAN) {
                    if (inputParam.isRedirection()) {
                        commandLine.append("> '").append(objectEntry.getValue().toString()).append("'");
                        continue;
                    }
                    if (inputParam.getDataType() == Param.Type.FILE || inputParam.getDataType() == Param.Type.FOLDER) {
                        commandLine.append("'").append(objectEntry.getValue().toString()).append("' ");
                        continue;
                    }
                    commandLine.append(objectEntry.getValue().toString()).append(" ");
                    continue;
                }
                if (inputParam.isFlag()) continue;
                commandLine.append(objectEntry.getValue()).append(" ");
                continue;
            }
            key = (String)objectEntry.getKey();
            if (!key.startsWith("-") && manifest.getSettings().isPosix()) {
                key = (key.length() > 1 ? "--" : "-") + key;
            }
            commandLine.append(key).append(manifest.getSettings().getSeparator());
            commandLine.append(objectEntry.getValue().toString()).append(" ");
        }
        return commandLine.toString();
    }

    public Manifest getManifest(String tool) throws AnalysisToolException {
        if (StringUtils.isEmpty((CharSequence)tool)) {
            throw new AnalysisToolException("Missing tool name information");
        }
        Manifest manifest = this.tools.get(tool);
        if (manifest != null) {
            return manifest;
        }
        Path toolPath = this.toolDirectory.resolve(tool + "/" + "manifest.json");
        if (!toolPath.toFile().exists()) {
            throw new AnalysisToolException("Missing manifest file in " + toolPath);
        }
        try {
            manifest = Manifest.load(new FileInputStream(toolPath.toFile()));
        }
        catch (IOException e) {
            this.logger.error("Error reading manifest file: {}", (Object)e.getMessage(), (Object)e);
            throw new AnalysisToolException(e.getMessage(), e.getCause());
        }
        this.tools.put(tool, manifest);
        return manifest;
    }

    public List<Param> getInputParams(String tool, String executionName) throws AnalysisToolException {
        Manifest manifest = this.getManifest(tool);
        Execution execution = null;
        for (Execution executionTmp : manifest.getExecutions()) {
            if (!executionTmp.getId().equalsIgnoreCase(executionName)) continue;
            execution = executionTmp;
            break;
        }
        if (execution == null) {
            throw new AnalysisToolException("Execution " + executionName + " not found in manifest");
        }
        return execution.getParams().stream().filter(param -> !param.isOutput() && param.getDataType().equals((Object)Param.Type.FILE)).collect(Collectors.toList());
    }

    public List<Param> getOutputParams(String tool, String executionName) throws AnalysisToolException {
        Manifest manifest = this.getManifest(tool);
        Execution execution = null;
        for (Execution executionTmp : manifest.getExecutions()) {
            if (!executionTmp.getId().equalsIgnoreCase(executionName)) continue;
            execution = executionTmp;
            break;
        }
        if (execution == null) {
            throw new AnalysisToolException("Execution " + executionName + " not found in manifest");
        }
        return execution.getParams().stream().filter(Param::isOutput).collect(Collectors.toList());
    }

    public void runCommandLine(String commandLine, Path outdir) throws AnalysisToolException {
        new Executor();
        Executor.execute(commandLine, outdir, false);
    }

    public void runCommandLine(String commandLine, Path outdir, boolean redirectLogs) throws AnalysisToolException {
        new Executor();
        Executor.execute(commandLine, outdir, redirectLogs);
    }

    private void checkToolDirectory() throws AnalysisToolException {
        if (this.toolDirectory == null || !this.toolDirectory.toFile().isDirectory()) {
            throw new AnalysisToolException("Path to tool directory not found");
        }
        try {
            Files.list(this.toolDirectory).forEach(path -> {
                if (path.toFile().isFile()) {
                    throw new RuntimeException("Found unexpected file in tool directory. Expecting only folders with tools");
                }
                if (!path.toFile().canRead()) {
                    throw new RuntimeException("Cannot read folder " + path);
                }
                if (!path.resolve("manifest.json").toFile().exists()) {
                    throw new RuntimeException("Manifest file not found under tool folder " + path);
                }
            });
        }
        catch (IOException e) {
            this.logger.error("{}", (Object)e.getMessage(), (Object)e);
            throw new AnalysisToolException(e.getMessage(), e.getCause());
        }
    }

    private void validateParams(Execution execution, Map<String, String> paramsMap) throws AnalysisToolException {
        Map<String, Param> manifestParams = execution.getParamsAsMap();
        HashSet<String> requiredParams = new HashSet<String>();
        for (Param param : execution.getParams()) {
            if (!param.isRequired()) continue;
            requiredParams.add(param.getName());
        }
        for (Map.Entry entry : paramsMap.entrySet()) {
            Param inputParam = manifestParams.get(entry.getKey());
            if (inputParam != null) {
                if (inputParam.isRequired()) {
                    requiredParams.remove(entry.getKey());
                }
                this.validateDataType(entry, inputParam);
                continue;
            }
            this.logger.info("Unknown parameter: {}", entry.getKey());
        }
        if (requiredParams.size() > 0) {
            throw new AnalysisToolException("Some mandatory parameters not found: " + StringUtils.join(requiredParams, (String)","));
        }
    }

    private void validateDataType(Map.Entry<String, String> entry, Param inputParam) throws AnalysisToolException {
        switch (inputParam.getDataType()) {
            case STRING: 
            case BOOLEAN: {
                break;
            }
            case NUMERIC: {
                if (StringUtils.isNumeric((CharSequence)entry.getValue())) break;
                throw new AnalysisToolException("Unexpected value for parameter " + entry.getKey() + ". Expecting a NUMERIC value");
            }
            case FILE: {
                Path path = Paths.get(String.valueOf(entry.getValue()), new String[0]);
                if (!inputParam.isOutput()) {
                    if (!path.toFile().exists()) {
                        throw new AnalysisToolException("Input file " + path.toString() + " not found");
                    }
                    if (!path.toFile().canRead()) {
                        throw new AnalysisToolException("Cannot read input file " + path.toString());
                    }
                    if (path.toFile().isFile()) break;
                    throw new AnalysisToolException("Input " + path.toString() + " is not a file");
                }
                if (path.toFile().exists()) {
                    if (!path.toFile().isFile()) {
                        throw new AnalysisToolException("Output " + path.toString() + " is not a file");
                    }
                    if (path.toFile().canWrite()) break;
                    throw new AnalysisToolException("Cannot write over file " + path.toString());
                }
                File dirPath = path.toFile().getParentFile();
                if (dirPath == null) {
                    throw new AnalysisToolException("Writing in the / folder is not allowed");
                }
                if (!dirPath.exists()) {
                    throw new AnalysisToolException("The folder " + dirPath.toString() + " to write the output file does not exist");
                }
                if (dirPath.canWrite()) break;
                throw new AnalysisToolException("Cannot create output file in " + dirPath.toString() + ". No write permissions.");
            }
            case FOLDER: {
                Path path = Paths.get(String.valueOf(entry.getValue()), new String[0]);
                if (!inputParam.isOutput()) {
                    if (!path.toFile().exists()) {
                        throw new AnalysisToolException("Input folder " + path.toString() + " not found");
                    }
                    if (!path.toFile().canRead()) {
                        throw new AnalysisToolException("Cannot read input folder " + path.toString());
                    }
                    if (path.toFile().isDirectory()) break;
                    throw new AnalysisToolException("Input " + path.toString() + " is not a directory");
                }
                if (!path.toFile().exists()) {
                    throw new AnalysisToolException("Output folder " + path.toString() + " not found");
                }
                if (!path.toFile().canWrite()) {
                    throw new AnalysisToolException("Cannot write on folder folder " + path.toString());
                }
                if (path.toFile().isDirectory()) break;
                throw new AnalysisToolException("Output " + path.toString() + " is not a directory");
            }
            default: {
                throw new AnalysisToolException("Unknown type of parameter " + inputParam.getName());
            }
        }
    }
}

