/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.analysis.tools;

import java.io.IOException;
import java.nio.file.Path;
import org.codehaus.jackson.map.ObjectMapper;
import org.opencb.hpg.bigdata.analysis.tools.Executor;
import org.opencb.hpg.bigdata.analysis.tools.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorMonitor {
    private static Logger logger = LoggerFactory.getLogger(Executor.class);
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static int threadInitNumber;
    private Path directory;
    private final int TIME = 5000;
    private Thread myThread;

    public void start(Path directory) {
        if (!directory.toFile().isDirectory()) {
            logger.error("Output directory {} is not an actual directory", (Object)directory);
            return;
        }
        if (!directory.toFile().canWrite()) {
            logger.error("Cannot write on output directory {}", (Object)directory);
            return;
        }
        this.directory = directory;
        Runnable statusProcess = () -> {
            Thread hook = new Thread(() -> {
                Status statusObject = new Status("ERROR");
                try {
                    objectMapper.writer().writeValue(this.directory.resolve("status.json").toFile(), (Object)statusObject);
                }
                catch (IOException e) {
                    logger.error("Could not write status {} to file", (Object)"ERROR", (Object)e);
                }
            });
            Runtime.getRuntime().addShutdownHook(hook);
            Status statusObject = new Status("RUNNING");
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    statusObject.setCurrentDate();
                    objectMapper.writer().writeValue(this.directory.resolve("status.json").toFile(), (Object)statusObject);
                }
                catch (IOException e) {
                    logger.error("Could not write status {} to file", (Object)"RUNNING", (Object)e);
                }
                try {
                    this.getClass();
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            Runtime.getRuntime().removeShutdownHook(hook);
        };
        this.myThread = new Thread(statusProcess, "StatusThread-" + ExecutorMonitor.nextThreadNum());
        this.myThread.start();
    }

    public void stop(Status status) {
        if (this.directory == null) {
            return;
        }
        this.myThread.interrupt();
        try {
            this.myThread.join();
        }
        catch (InterruptedException e) {
            logger.error("Thread is alive? {}", (Object)(this.myThread.isAlive() ? "true" : "false"));
        }
        try {
            objectMapper.writer().writeValue(this.directory.resolve("status.json").toFile(), (Object)status);
        }
        catch (IOException e) {
            logger.error("Could not write status {} to file", (Object)status.getName(), (Object)e);
        }
    }

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }
}

