/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.analysis.sequence.stats;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.opencb.biodata.models.sequence.Read;
import org.opencb.biodata.tools.alignment.stats.SequenceStats;
import org.opencb.biodata.tools.alignment.stats.SequenceStatsCalculator;
import org.opencb.hpg.bigdata.analysis.sequence.stats.ReadStatsWritable;

public class ReadStatsMR {
    public static int run(String input, String output, int kvalue) throws Exception {
        Configuration conf = new Configuration();
        conf.set("kvalue", String.valueOf(kvalue));
        Job job = Job.getInstance((Configuration)conf, (String)"ReadStatsMR");
        job.setJarByClass(ReadStatsMR.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(input)});
        job.setInputFormatClass(AvroKeyInputFormat.class);
        AvroJob.setInputKeySchema((Job)job, (Schema)Read.SCHEMA$);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(output));
        job.setOutputKeyClass(ReadStatsWritable.class);
        job.setOutputValueClass(NullWritable.class);
        job.setMapperClass(ReadStatsMapper.class);
        job.setMapOutputKeyClass(LongWritable.class);
        job.setMapOutputValueClass(ReadStatsWritable.class);
        job.setCombinerClass(ReadStatsCombiner.class);
        job.setReducerClass(ReadStatsReducer.class);
        job.setNumReduceTasks(1);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static class ReadStatsReducer
    extends Reducer<LongWritable, ReadStatsWritable, Text, NullWritable> {
        public void reduce(LongWritable key, Iterable<ReadStatsWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int kvalue = Integer.parseInt(context.getConfiguration().get("kvalue"));
            SequenceStats stats = new SequenceStats(kvalue);
            SequenceStatsCalculator calculator = new SequenceStatsCalculator();
            for (ReadStatsWritable value : values) {
                calculator.update(value.getStats(), stats);
            }
            context.write((Object)new Text(stats.toJSON()), (Object)NullWritable.get());
        }
    }

    public static class ReadStatsCombiner
    extends Reducer<LongWritable, ReadStatsWritable, LongWritable, ReadStatsWritable> {
        public void reduce(LongWritable key, Iterable<ReadStatsWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int kvalue = Integer.parseInt(context.getConfiguration().get("kvalue"));
            SequenceStats stats = new SequenceStats(kvalue);
            SequenceStatsCalculator calculator = new SequenceStatsCalculator();
            for (ReadStatsWritable value : values) {
                calculator.update(value.getStats(), stats);
            }
            context.write((Object)new LongWritable(1L), (Object)new ReadStatsWritable(stats));
        }
    }

    public static class ReadStatsMapper
    extends Mapper<AvroKey<Read>, NullWritable, LongWritable, ReadStatsWritable> {
        private int newKey;
        private int numRecords;
        private final int MAX_NUM_AVRO_RECORDS = 1000;
        private static int kvalue = 0;

        public void setup(Mapper.Context context) {
            Configuration conf = context.getConfiguration();
            kvalue = Integer.parseInt(conf.get("kvalue"));
            this.newKey = 0;
            this.numRecords = 0;
        }

        public void map(AvroKey<Read> key, NullWritable value, Mapper.Context ctx) throws IOException, InterruptedException {
            SequenceStats stats = new SequenceStatsCalculator().compute((Read)key.datum(), kvalue);
            ctx.write((Object)new LongWritable((long)this.newKey), (Object)new ReadStatsWritable(stats));
            ++this.numRecords;
            if (this.numRecords >= 1000) {
                ++this.newKey;
                this.numRecords = 0;
            }
        }
    }
}

