/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.analysis.sequence.stats;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.opencb.biodata.models.sequence.Read;
import org.opencb.biodata.tools.alignment.stats.SequenceKmers;
import org.opencb.biodata.tools.alignment.stats.SequenceKmersCalculator;
import org.opencb.hpg.bigdata.analysis.sequence.stats.ReadKmersWritable;

public class ReadKmersMR {
    public static int run(String input, String output, int kvalue) throws Exception {
        Configuration conf = new Configuration();
        conf.set("kvalue", String.valueOf(kvalue));
        System.out.println("run: kvalue = " + kvalue);
        Job job = Job.getInstance((Configuration)conf, (String)"ReadKmersMR");
        job.setJarByClass(ReadKmersMR.class);
        AvroJob.setInputKeySchema((Job)job, (Schema)Read.getClassSchema());
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(input)});
        job.setInputFormatClass(AvroKeyInputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(output));
        job.setOutputKeyClass(ReadKmersWritable.class);
        job.setOutputValueClass(NullWritable.class);
        job.setMapperClass(ReadKmersMapper.class);
        job.setMapOutputKeyClass(LongWritable.class);
        job.setMapOutputValueClass(ReadKmersWritable.class);
        job.setCombinerClass(ReadKmersCombiner.class);
        job.setReducerClass(ReadKmersReducer.class);
        job.setNumReduceTasks(1);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static class ReadKmersReducer
    extends Reducer<LongWritable, ReadKmersWritable, Text, NullWritable> {
        private int kvalue = 0;

        public void setup(Mapper.Context context) {
            Configuration conf = context.getConfiguration();
            this.kvalue = Integer.parseInt(conf.get("kvalue"));
            System.out.println("setup reducer: kvalue = " + this.kvalue);
        }

        public void reduce(LongWritable key, Iterable<ReadKmersWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            SequenceKmers kmers = new SequenceKmers(this.kvalue);
            System.out.println("00 kvalue = " + this.kvalue + ", " + kmers.getKvalue());
            SequenceKmersCalculator calculator = new SequenceKmersCalculator();
            for (ReadKmersWritable value : values) {
                calculator.update(value.getKmers(), kmers);
            }
            context.write((Object)new Text(kmers.toJSON()), (Object)NullWritable.get());
            System.out.println("11 kvalue = " + this.kvalue + ", " + kmers.getKvalue());
        }
    }

    public static class ReadKmersCombiner
    extends Reducer<LongWritable, ReadKmersWritable, LongWritable, ReadKmersWritable> {
        private int kvalue = 0;

        public void setup(Mapper.Context context) {
            Configuration conf = context.getConfiguration();
            this.kvalue = Integer.parseInt(conf.get("kvalue"));
            System.out.println("setup combiner: kvalue = " + this.kvalue);
        }

        public void reduce(LongWritable key, Iterable<ReadKmersWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            SequenceKmers kmers = new SequenceKmers(this.kvalue);
            SequenceKmersCalculator calculator = new SequenceKmersCalculator();
            for (ReadKmersWritable value : values) {
                calculator.update(value.getKmers(), kmers);
            }
            context.write((Object)new LongWritable(1L), (Object)new ReadKmersWritable(kmers));
        }
    }

    public static class ReadKmersMapper
    extends Mapper<AvroKey<Read>, NullWritable, LongWritable, ReadKmersWritable> {
        private int kvalue = 0;
        private int newKey;
        private int numRecords;
        private final int MAX_NUM_AVRO_RECORDS = 1000;

        public void setup(Mapper.Context context) {
            Configuration conf = context.getConfiguration();
            this.kvalue = Integer.parseInt(conf.get("kvalue"));
            System.out.println("setup mapper: kvalue = " + this.kvalue);
            this.newKey = 0;
            this.numRecords = 0;
        }

        public void map(AvroKey<Read> key, NullWritable value, Mapper.Context ctx) throws IOException, InterruptedException {
            SequenceKmers kmers = new SequenceKmersCalculator().compute((Read)key.datum(), this.kvalue);
            ctx.write((Object)new LongWritable((long)this.newKey), (Object)new ReadKmersWritable(kmers));
            ++this.numRecords;
            if (this.numRecords >= 1000) {
                ++this.newKey;
                this.numRecords = 0;
            }
        }
    }
}

