/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.analysis.sequence;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyOutputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.opencb.biodata.models.sequence.Read;
import org.opencb.hpg.bigdata.analysis.sequence.FastqInputFormatMODIF;
import org.opencb.hpg.bigdata.core.utils.CompressionUtils;
import org.seqdoop.hadoop_bam.SequencedFragment;

public class Fastq2AvroMR {
    public static int run(String input, String output, String codecName) throws Exception {
        Configuration conf = new Configuration();
        Job job = Job.getInstance((Configuration)conf, (String)"Fastq2AvroMR");
        job.setJarByClass(Fastq2AvroMR.class);
        AvroJob.setOutputKeySchema((Job)job, (Schema)Read.SCHEMA$);
        job.setOutputValueClass(NullWritable.class);
        AvroJob.setMapOutputValueSchema((Job)job, (Schema)Read.SCHEMA$);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(input)});
        job.setInputFormatClass(FastqInputFormatMODIF.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(output));
        if (codecName != null) {
            FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
            FileOutputFormat.setOutputCompressorClass((Job)job, (Class)CompressionUtils.getHadoopCodec((String)codecName));
        }
        job.setOutputFormatClass(AvroKeyOutputFormat.class);
        job.setMapOutputKeyClass(LongWritable.class);
        job.setMapOutputValueClass(AvroValue.class);
        job.setMapperClass(Fastq2GaMapper.class);
        job.setReducerClass(Fastq2GaReducer.class);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static class Fastq2GaReducer
    extends Reducer<LongWritable, AvroValue<Read>, AvroKey<Read>, NullWritable> {
        public void reduce(LongWritable key, Iterable<AvroValue<Read>> values, Reducer.Context context) throws IOException, InterruptedException {
            for (AvroValue<Read> value : values) {
                context.write((Object)new AvroKey(value.datum()), (Object)NullWritable.get());
            }
        }
    }

    public static class Fastq2GaMapper
    extends Mapper<Text, SequencedFragment, LongWritable, AvroValue<Read>> {
        public void map(Text key, SequencedFragment value, Mapper.Context context) throws IOException, InterruptedException {
            Read read = new Read(key.toString(), value.getSequence().toString(), value.getQuality().toString());
            context.write((Object)new LongWritable(1L), (Object)new AvroValue((Object)read));
        }
    }
}

