/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.analysis.alignment.stats;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.ga4gh.models.ReadAlignment;
import org.opencb.biodata.tools.alignment.stats.AlignmentGlobalStats;
import org.opencb.biodata.tools.alignment.stats.AvroAlignmentGlobalStatsCalculator;
import org.opencb.hpg.bigdata.analysis.sequence.stats.ReadAlignmentStatsWritable;
import org.opencb.hpg.bigdata.analysis.sequence.stats.ReadStatsWritable;

public class ReadAlignmentStatsMR {
    public static int run(String input, String output) throws Exception {
        Configuration conf = new Configuration();
        Job job = Job.getInstance((Configuration)conf, (String)"ReadAlignmentStatsMR");
        job.setJarByClass(ReadAlignmentStatsMR.class);
        AvroJob.setInputKeySchema((Job)job, (Schema)ReadAlignment.getClassSchema());
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(input)});
        job.setInputFormatClass(AvroKeyInputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(output));
        job.setOutputKeyClass(ReadStatsWritable.class);
        job.setOutputValueClass(NullWritable.class);
        job.setMapperClass(ReadAlignmentStatsMapper.class);
        job.setMapOutputKeyClass(LongWritable.class);
        job.setMapOutputValueClass(ReadAlignmentStatsWritable.class);
        job.setCombinerClass(ReadAlignmentStatsCombiner.class);
        job.setReducerClass(ReadAlignmentStatsReducer.class);
        job.setNumReduceTasks(1);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static class ReadAlignmentStatsReducer
    extends Reducer<LongWritable, ReadAlignmentStatsWritable, Text, NullWritable> {
        public void reduce(LongWritable key, Iterable<ReadAlignmentStatsWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            AlignmentGlobalStats stats = new AlignmentGlobalStats();
            AvroAlignmentGlobalStatsCalculator calculator = new AvroAlignmentGlobalStatsCalculator();
            for (ReadAlignmentStatsWritable value : values) {
                calculator.update(value.getStats(), stats);
            }
            context.write((Object)new Text(stats.toJSON()), (Object)NullWritable.get());
        }
    }

    public static class ReadAlignmentStatsCombiner
    extends Reducer<LongWritable, ReadAlignmentStatsWritable, LongWritable, ReadAlignmentStatsWritable> {
        public void reduce(LongWritable key, Iterable<ReadAlignmentStatsWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            AlignmentGlobalStats stats = new AlignmentGlobalStats();
            AvroAlignmentGlobalStatsCalculator calculator = new AvroAlignmentGlobalStatsCalculator();
            for (ReadAlignmentStatsWritable value : values) {
                calculator.update(value.getStats(), stats);
            }
            context.write((Object)new LongWritable(1L), (Object)new ReadAlignmentStatsWritable(stats));
        }
    }

    public static class ReadAlignmentStatsMapper
    extends Mapper<AvroKey<ReadAlignment>, NullWritable, LongWritable, ReadAlignmentStatsWritable> {
        private int newKey;
        private int numRecords;
        private final int MAX_NUM_AVRO_RECORDS = 1000;

        public void setup(Mapper.Context context) {
            this.newKey = 0;
            this.numRecords = 0;
        }

        public void map(AvroKey<ReadAlignment> key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
            if (key.datum() == null) {
                return;
            }
            AlignmentGlobalStats stats = new AvroAlignmentGlobalStatsCalculator().compute(key.datum());
            context.write((Object)new LongWritable((long)this.newKey), (Object)new ReadAlignmentStatsWritable(stats));
            ++this.numRecords;
            if (this.numRecords >= 1000) {
                ++this.newKey;
                this.numRecords = 0;
            }
        }
    }
}

