/*
 * Decompiled with CFR 0.152.
 */
package org.opencb.hpg.bigdata.analysis.alignment.stats;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyInputFormat;
import org.apache.avro.mapreduce.AvroKeyOutputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.ga4gh.models.LinearAlignment;
import org.ga4gh.models.ReadAlignment;
import org.opencb.hpg.bigdata.analysis.utils.ChunkKey;

public class ReadAlignmentSortMR {
    public static int run(String input, String output) throws Exception {
        Configuration conf = new Configuration();
        Job job = Job.getInstance((Configuration)conf, (String)"ReadAlignmentSortMR");
        job.setJarByClass(ReadAlignmentSortMR.class);
        AvroJob.setInputKeySchema((Job)job, (Schema)ReadAlignment.SCHEMA$);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(input)});
        job.setInputFormatClass(AvroKeyInputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(output));
        job.setOutputFormatClass(AvroKeyOutputFormat.class);
        job.setMapperClass(ReadAlignmentSortMapper.class);
        AvroJob.setMapOutputValueSchema((Job)job, (Schema)ReadAlignment.SCHEMA$);
        job.setMapOutputKeyClass(ChunkKey.class);
        job.setReducerClass(ReadAlignmentSortReducer.class);
        AvroJob.setOutputKeySchema((Job)job, (Schema)ReadAlignment.SCHEMA$);
        conf.set("mapred.compress.map.output", "true");
        conf.set("mapred.map.output.compression.codec", "org.apache.hadoop.io.compress.SnappyCodec");
        conf.set("mapred.output.compress", "true");
        conf.set("mapred.output.compression", "org.apache.hadoop.io.compress.SnappyCodec");
        job.waitForCompletion(true);
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path srcHeaderPath = new Path(input + ".header");
        FSDataInputStream dis = fs.open(srcHeaderPath);
        FileStatus status = fs.getFileStatus(srcHeaderPath);
        byte[] data = new byte[(int)status.getLen()];
        dis.read(data, 0, (int)status.getLen());
        dis.close();
        FSDataOutputStream os = fs.create(new Path(output + "/part-r-00000.avro.header"));
        os.write(data);
        os.close();
        return 0;
    }

    public static class ReadAlignmentSortReducer
    extends Reducer<ChunkKey, AvroValue<ReadAlignment>, AvroKey<ReadAlignment>, NullWritable> {
        public void reduce(ChunkKey key, Iterable<AvroValue<ReadAlignment>> values, Reducer.Context context) throws IOException, InterruptedException {
            for (AvroValue<ReadAlignment> value : values) {
                context.write((Object)new AvroKey(value.datum()), (Object)NullWritable.get());
            }
        }
    }

    public static class ReadAlignmentSortMapper
    extends Mapper<AvroKey<ReadAlignment>, NullWritable, ChunkKey, AvroValue<ReadAlignment>> {
        public void map(AvroKey<ReadAlignment> key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
            LinearAlignment la = ((ReadAlignment)key.datum()).getAlignment();
            ChunkKey newKey = la == null ? new ChunkKey(new String("*"), 0) : new ChunkKey(la.getPosition().getReferenceName().toString(), la.getPosition().getPosition().intValue());
            context.write((Object)newKey, (Object)new AvroValue(key.datum()));
        }
    }
}

