/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Schema;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedExtensions;
import org.openapitools.openapidiff.core.model.ChangedMetadata;
import org.openapitools.openapidiff.core.model.ChangedOneOfSchema;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;
import org.openapitools.openapidiff.core.model.schema.ChangedEnum;
import org.openapitools.openapidiff.core.model.schema.ChangedMaxLength;
import org.openapitools.openapidiff.core.model.schema.ChangedReadOnly;
import org.openapitools.openapidiff.core.model.schema.ChangedRequired;
import org.openapitools.openapidiff.core.model.schema.ChangedWriteOnly;

public class ChangedSchema
implements ComposedChanged {
    protected DiffContext context;
    protected Schema oldSchema;
    protected Schema newSchema;
    protected String type;
    protected Map<String, ChangedSchema> changedProperties;
    protected Map<String, Schema> increasedProperties = new LinkedHashMap<String, Schema>();
    protected Map<String, Schema> missingProperties = new LinkedHashMap<String, Schema>();
    protected boolean changeDeprecated;
    protected ChangedMetadata description;
    protected boolean changeTitle;
    protected ChangedRequired required;
    protected boolean changeDefault;
    protected ChangedEnum<?> enumeration;
    protected boolean changeFormat;
    protected ChangedReadOnly readOnly;
    protected ChangedWriteOnly writeOnly;
    protected boolean changedType;
    protected ChangedMaxLength maxLength;
    protected boolean discriminatorPropertyChanged;
    protected ChangedSchema items;
    protected ChangedOneOfSchema oneOfSchema;
    protected ChangedSchema addProp;
    private ChangedExtensions extensions;

    public ChangedSchema() {
        this.changedProperties = new LinkedHashMap<String, ChangedSchema>();
    }

    @Override
    public List<Changed> getChangedElements() {
        return Stream.concat(this.changedProperties.values().stream(), Stream.of(this.description, this.readOnly, this.writeOnly, this.items, this.oneOfSchema, this.addProp, this.enumeration, this.required, this.maxLength, this.extensions)).collect(Collectors.toList());
    }

    @Override
    public DiffResult isCoreChanged() {
        boolean compatibleForResponse;
        if (!this.changedType && (this.oldSchema == null && this.newSchema == null || this.oldSchema != null && this.newSchema != null) && !this.changeFormat && this.increasedProperties.isEmpty() && this.missingProperties.isEmpty() && this.changedProperties.values().isEmpty() && !this.changeDeprecated && !this.discriminatorPropertyChanged) {
            return DiffResult.NO_CHANGES;
        }
        boolean bl = compatibleForResponse = this.missingProperties.isEmpty() && (this.oldSchema == null || this.newSchema != null);
        if ((this.context.isRequest() && this.compatibleForRequest() || this.context.isResponse() && compatibleForResponse) && !this.changedType && !this.discriminatorPropertyChanged) {
            return DiffResult.COMPATIBLE;
        }
        return DiffResult.INCOMPATIBLE;
    }

    private boolean compatibleForRequest() {
        if (PathItem.HttpMethod.PUT.equals((Object)this.context.getMethod()) && this.increasedProperties.size() > 0) {
            return false;
        }
        return this.oldSchema != null || this.newSchema == null;
    }

    public DiffContext getContext() {
        return this.context;
    }

    public Schema getOldSchema() {
        return this.oldSchema;
    }

    public Schema getNewSchema() {
        return this.newSchema;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, ChangedSchema> getChangedProperties() {
        return this.changedProperties;
    }

    public Map<String, Schema> getIncreasedProperties() {
        return this.increasedProperties;
    }

    public Map<String, Schema> getMissingProperties() {
        return this.missingProperties;
    }

    public boolean isChangeDeprecated() {
        return this.changeDeprecated;
    }

    public ChangedMetadata getDescription() {
        return this.description;
    }

    public boolean isChangeTitle() {
        return this.changeTitle;
    }

    public ChangedRequired getRequired() {
        return this.required;
    }

    public boolean isChangeDefault() {
        return this.changeDefault;
    }

    public ChangedEnum<?> getEnumeration() {
        return this.enumeration;
    }

    public boolean isChangeFormat() {
        return this.changeFormat;
    }

    public ChangedReadOnly getReadOnly() {
        return this.readOnly;
    }

    public ChangedWriteOnly getWriteOnly() {
        return this.writeOnly;
    }

    public boolean isChangedType() {
        return this.changedType;
    }

    public ChangedMaxLength getMaxLength() {
        return this.maxLength;
    }

    public boolean isDiscriminatorPropertyChanged() {
        return this.discriminatorPropertyChanged;
    }

    public ChangedSchema getItems() {
        return this.items;
    }

    public ChangedOneOfSchema getOneOfSchema() {
        return this.oneOfSchema;
    }

    public ChangedSchema getAddProp() {
        return this.addProp;
    }

    public ChangedExtensions getExtensions() {
        return this.extensions;
    }

    public ChangedSchema setContext(DiffContext context) {
        this.context = context;
        return this;
    }

    public ChangedSchema setOldSchema(Schema oldSchema) {
        this.oldSchema = oldSchema;
        return this;
    }

    public ChangedSchema setNewSchema(Schema newSchema) {
        this.newSchema = newSchema;
        return this;
    }

    public ChangedSchema setType(String type) {
        this.type = type;
        return this;
    }

    public ChangedSchema setChangedProperties(Map<String, ChangedSchema> changedProperties) {
        this.changedProperties = changedProperties;
        return this;
    }

    public ChangedSchema setIncreasedProperties(Map<String, Schema> increasedProperties) {
        this.increasedProperties = increasedProperties;
        return this;
    }

    public ChangedSchema setMissingProperties(Map<String, Schema> missingProperties) {
        this.missingProperties = missingProperties;
        return this;
    }

    public ChangedSchema setChangeDeprecated(boolean changeDeprecated) {
        this.changeDeprecated = changeDeprecated;
        return this;
    }

    public ChangedSchema setDescription(ChangedMetadata description) {
        this.description = description;
        return this;
    }

    public ChangedSchema setChangeTitle(boolean changeTitle) {
        this.changeTitle = changeTitle;
        return this;
    }

    public ChangedSchema setRequired(ChangedRequired required) {
        this.required = required;
        return this;
    }

    public ChangedSchema setChangeDefault(boolean changeDefault) {
        this.changeDefault = changeDefault;
        return this;
    }

    public ChangedSchema setEnumeration(ChangedEnum<?> enumeration) {
        this.enumeration = enumeration;
        return this;
    }

    public ChangedSchema setChangeFormat(boolean changeFormat) {
        this.changeFormat = changeFormat;
        return this;
    }

    public ChangedSchema setReadOnly(ChangedReadOnly readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public ChangedSchema setWriteOnly(ChangedWriteOnly writeOnly) {
        this.writeOnly = writeOnly;
        return this;
    }

    public ChangedSchema setChangedType(boolean changedType) {
        this.changedType = changedType;
        return this;
    }

    public ChangedSchema setMaxLength(ChangedMaxLength maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public ChangedSchema setDiscriminatorPropertyChanged(boolean discriminatorPropertyChanged) {
        this.discriminatorPropertyChanged = discriminatorPropertyChanged;
        return this;
    }

    public ChangedSchema setItems(ChangedSchema items) {
        this.items = items;
        return this;
    }

    public ChangedSchema setOneOfSchema(ChangedOneOfSchema oneOfSchema) {
        this.oneOfSchema = oneOfSchema;
        return this;
    }

    public ChangedSchema setAddProp(ChangedSchema addProp) {
        this.addProp = addProp;
        return this;
    }

    public ChangedSchema setExtensions(ChangedExtensions extensions) {
        this.extensions = extensions;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedSchema that = (ChangedSchema)o;
        return this.changeDeprecated == that.changeDeprecated && this.changeTitle == that.changeTitle && this.changeDefault == that.changeDefault && this.changeFormat == that.changeFormat && this.changedType == that.changedType && this.discriminatorPropertyChanged == that.discriminatorPropertyChanged && Objects.equals(this.context, that.context) && Objects.equals(this.oldSchema, that.oldSchema) && Objects.equals(this.newSchema, that.newSchema) && Objects.equals(this.type, that.type) && Objects.equals(this.changedProperties, that.changedProperties) && Objects.equals(this.increasedProperties, that.increasedProperties) && Objects.equals(this.missingProperties, that.missingProperties) && Objects.equals(this.description, that.description) && Objects.equals(this.required, that.required) && Objects.equals(this.enumeration, that.enumeration) && Objects.equals(this.readOnly, that.readOnly) && Objects.equals(this.writeOnly, that.writeOnly) && Objects.equals(this.maxLength, that.maxLength) && Objects.equals(this.items, that.items) && Objects.equals(this.oneOfSchema, that.oneOfSchema) && Objects.equals(this.addProp, that.addProp) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.oldSchema, this.newSchema, this.type, this.changedProperties, this.increasedProperties, this.missingProperties, this.changeDeprecated, this.description, this.changeTitle, this.required, this.changeDefault, this.enumeration, this.changeFormat, this.readOnly, this.writeOnly, this.changedType, this.maxLength, this.discriminatorPropertyChanged, this.items, this.oneOfSchema, this.addProp, this.extensions);
    }

    public String toString() {
        return "ChangedSchema(context=" + this.getContext() + ", oldSchema=" + this.getOldSchema() + ", newSchema=" + this.getNewSchema() + ", type=" + this.getType() + ", changedProperties=" + this.getChangedProperties() + ", increasedProperties=" + this.getIncreasedProperties() + ", missingProperties=" + this.getMissingProperties() + ", changeDeprecated=" + this.isChangeDeprecated() + ", description=" + this.getDescription() + ", changeTitle=" + this.isChangeTitle() + ", required=" + this.getRequired() + ", changeDefault=" + this.isChangeDefault() + ", enumeration=" + this.getEnumeration() + ", changeFormat=" + this.isChangeFormat() + ", readOnly=" + this.getReadOnly() + ", writeOnly=" + this.getWriteOnly() + ", changedType=" + this.isChangedType() + ", maxLength=" + this.getMaxLength() + ", discriminatorPropertyChanged=" + this.isDiscriminatorPropertyChanged() + ", items=" + this.getItems() + ", oneOfSchema=" + this.getOneOfSchema() + ", addProp=" + this.getAddProp() + ", extensions=" + this.getExtensions() + ")";
    }
}

