/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.model.ChangedSecurityRequirement;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.utils.ChangedUtils;

public class SecurityRequirementDiff {
    private final OpenApiDiff openApiDiff;
    private final Components leftComponents;
    private final Components rightComponents;

    public SecurityRequirementDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
        this.leftComponents = openApiDiff.getOldSpecOpenApi() != null ? openApiDiff.getOldSpecOpenApi().getComponents() : null;
        this.rightComponents = openApiDiff.getNewSpecOpenApi() != null ? openApiDiff.getNewSpecOpenApi().getComponents() : null;
    }

    public static SecurityRequirement getCopy(LinkedHashMap<String, List<String>> right) {
        SecurityRequirement newSecurityRequirement = new SecurityRequirement();
        right.forEach((key, value) -> newSecurityRequirement.put(key, new ArrayList(value)));
        return newSecurityRequirement;
    }

    private LinkedHashMap<String, List<String>> contains(SecurityRequirement right, String schemeRef) {
        SecurityScheme leftSecurityScheme = (SecurityScheme)this.leftComponents.getSecuritySchemes().get(schemeRef);
        LinkedHashMap<String, List<String>> found = new LinkedHashMap<String, List<String>>();
        for (Map.Entry entry : right.entrySet()) {
            SecurityScheme rightSecurityScheme = (SecurityScheme)this.rightComponents.getSecuritySchemes().get(entry.getKey());
            if (leftSecurityScheme.getType() != rightSecurityScheme.getType()) continue;
            switch (leftSecurityScheme.getType()) {
                case APIKEY: {
                    if (!leftSecurityScheme.getName().equals(rightSecurityScheme.getName())) break;
                    found.put((String)entry.getKey(), (List)entry.getValue());
                    return found;
                }
                case OAUTH2: 
                case HTTP: 
                case OPENIDCONNECT: {
                    found.put((String)entry.getKey(), (List)entry.getValue());
                    return found;
                }
            }
        }
        return found;
    }

    public Optional<ChangedSecurityRequirement> diff(SecurityRequirement left, SecurityRequirement right, DiffContext context) {
        ChangedSecurityRequirement changedSecurityRequirement = new ChangedSecurityRequirement(left, right != null ? SecurityRequirementDiff.getCopy((LinkedHashMap<String, List<String>>)right) : null);
        SecurityRequirement leftRequirement = left == null ? new SecurityRequirement() : left;
        SecurityRequirement rightRequirement = right == null ? new SecurityRequirement() : right;
        for (Map.Entry leftEntry : leftRequirement.entrySet()) {
            LinkedHashMap<String, List<String>> rightSec = this.contains(rightRequirement, (String)leftEntry.getKey());
            if (rightSec.isEmpty()) {
                changedSecurityRequirement.addMissing((String)leftEntry.getKey(), (List)leftEntry.getValue());
                continue;
            }
            Optional rightSchemeRef = rightSec.keySet().stream().findFirst();
            rightSchemeRef.ifPresent(arg_0 -> rightRequirement.remove(arg_0));
            rightSchemeRef.flatMap(rightScheme -> this.openApiDiff.getSecuritySchemeDiff().diff((String)leftEntry.getKey(), (List)leftEntry.getValue(), (String)rightScheme, (List)rightSec.get(rightScheme), context)).ifPresent(changedSecurityRequirement::addChanged);
        }
        rightRequirement.forEach(changedSecurityRequirement::addIncreased);
        return ChangedUtils.isChanged(changedSecurityRequirement);
    }
}

