/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare;

import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.List;
import java.util.Optional;
import org.openapitools.openapidiff.core.compare.ListDiff;
import org.openapitools.openapidiff.core.model.ChangedList;

public class SecurityDiffInfo {
    private String ref;
    private SecurityScheme securityScheme;
    private List<String> scopes;

    public SecurityDiffInfo(String ref, SecurityScheme securityScheme, List<String> scopes) {
        this.ref = ref;
        this.securityScheme = securityScheme;
        this.scopes = scopes;
    }

    public static SecurityRequirement getSecurityRequirement(List<SecurityDiffInfo> securityDiffInfoList) {
        SecurityRequirement securityRequirement = new SecurityRequirement();
        for (SecurityDiffInfo securityDiffInfo : securityDiffInfoList) {
            securityRequirement.put((Object)securityDiffInfo.getRef(), securityDiffInfo.getScopes());
        }
        return securityRequirement;
    }

    public static Optional<List<SecurityDiffInfo>> containsList(List<List<SecurityDiffInfo>> securityRequirements, List<SecurityDiffInfo> leftSecurities) {
        return securityRequirements.stream().filter(rightSecurities -> SecurityDiffInfo.sameList(leftSecurities, rightSecurities)).findFirst();
    }

    public static boolean sameList(List<SecurityDiffInfo> leftSecurities, List<SecurityDiffInfo> rightSecurities) {
        return ListDiff.diff(new ChangedList.SimpleChangedList<SecurityDiffInfo>(leftSecurities, rightSecurities)).isUnchanged();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityDiffInfo that = (SecurityDiffInfo)o;
        if (this.securityScheme != null ? !this.securityScheme.equals((Object)that.securityScheme) : that.securityScheme != null) {
            return false;
        }
        return this.scopes != null ? this.scopes.equals(that.scopes) : that.scopes == null;
    }

    public int hashCode() {
        int result = this.securityScheme != null ? this.securityScheme.hashCode() : 0;
        result = 31 * result + (this.scopes != null ? this.scopes.hashCode() : 0);
        return result;
    }

    public String getRef() {
        return this.ref;
    }

    public SecurityScheme getSecurityScheme() {
        return this.securityScheme;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public void setSecurityScheme(SecurityScheme securityScheme) {
        this.securityScheme = securityScheme;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public String toString() {
        return "SecurityDiffInfo(ref=" + this.getRef() + ", securityScheme=" + this.getSecurityScheme() + ", scopes=" + this.getScopes() + ")";
    }
}

