/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare;

import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.model.ChangedPath;
import org.openapitools.openapidiff.core.model.ChangedPaths;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.utils.ChangedUtils;

public class PathsDiff {
    private static final String REGEX_PATH = "\\{([^/]+)\\}";
    private final OpenApiDiff openApiDiff;

    public PathsDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
    }

    private static String normalizePath(String path) {
        return path.replaceAll(REGEX_PATH, "{}");
    }

    private static List<String> extractParameters(String path) {
        ArrayList<String> params = new ArrayList<String>();
        Pattern pattern = Pattern.compile(REGEX_PATH);
        Matcher matcher = pattern.matcher(path);
        while (matcher.find()) {
            params.add(matcher.group(1));
        }
        return params;
    }

    public Optional<ChangedPaths> diff(Map<String, PathItem> left, Map<String, PathItem> right) {
        ChangedPaths changedPaths = new ChangedPaths(left, right);
        changedPaths.getIncreased().putAll(right);
        left.keySet().forEach(url -> {
            PathItem leftPath = (PathItem)left.get(url);
            String template = PathsDiff.normalizePath(url);
            Optional<Map.Entry> result = changedPaths.getIncreased().entrySet().stream().filter(item -> PathsDiff.normalizePath((String)item.getKey()).equals(template)).min((a, b) -> {
                if (PathsDiff.methodsIntersect((PathItem)a.getValue(), (PathItem)b.getValue())) {
                    throw new IllegalArgumentException("Two path items have the same signature: " + template);
                }
                if (((String)a.getKey()).equals(url)) {
                    return -1;
                }
                if (((String)b.getKey()).equals(url)) {
                    return 1;
                }
                HashSet methodsA = new HashSet(((PathItem)a.getValue()).readOperationsMap().keySet());
                methodsA.retainAll(leftPath.readOperationsMap().keySet());
                HashSet methodsB = new HashSet(((PathItem)b.getValue()).readOperationsMap().keySet());
                methodsB.retainAll(leftPath.readOperationsMap().keySet());
                return Integer.compare(methodsB.size(), methodsA.size());
            });
            if (result.isPresent()) {
                String rightUrl = (String)result.get().getKey();
                PathItem rightPath = changedPaths.getIncreased().remove(rightUrl);
                LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                if (!url.equals(rightUrl)) {
                    List<String> oldParams = PathsDiff.extractParameters(url);
                    List<String> newParams = PathsDiff.extractParameters(rightUrl);
                    for (int i = 0; i < oldParams.size(); ++i) {
                        params.put(oldParams.get(i), newParams.get(i));
                    }
                }
                DiffContext context = new DiffContext();
                context.setUrl((String)url);
                context.setParameters(params);
                this.openApiDiff.getPathDiff().diff(leftPath, rightPath, context).ifPresent(path -> changedPaths.getChanged().put(rightUrl, (ChangedPath)path));
            } else {
                changedPaths.getMissing().put((String)url, leftPath);
            }
        });
        return ChangedUtils.isChanged(changedPaths);
    }

    public static Paths valOrEmpty(Paths path) {
        if (path == null) {
            path = new Paths();
        }
        return path;
    }

    private static boolean methodsIntersect(PathItem a, PathItem b) {
        Set methodsA = a.readOperationsMap().keySet();
        for (PathItem.HttpMethod method : b.readOperationsMap().keySet()) {
            if (!methodsA.contains(method)) continue;
            return true;
        }
        return false;
    }
}

