/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.model.ChangedParameters;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.utils.ChangedUtils;
import org.openapitools.openapidiff.core.utils.RefPointer;
import org.openapitools.openapidiff.core.utils.RefType;

public class ParametersDiff {
    private static final RefPointer<Parameter> refPointer = new RefPointer(RefType.PARAMETERS);
    private final Components leftComponents;
    private final Components rightComponents;
    private final OpenApiDiff openApiDiff;

    public ParametersDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
        this.leftComponents = openApiDiff.getOldSpecOpenApi() != null ? openApiDiff.getOldSpecOpenApi().getComponents() : null;
        this.rightComponents = openApiDiff.getNewSpecOpenApi() != null ? openApiDiff.getNewSpecOpenApi().getComponents() : null;
    }

    public static Optional<Parameter> contains(Components components, List<Parameter> parameters, Parameter parameter) {
        return parameters.stream().filter(param -> ParametersDiff.same(refPointer.resolveRef(components, (Parameter)param, param.get$ref()), parameter)).findFirst();
    }

    public static boolean same(Parameter left, Parameter right) {
        return Objects.equals(left.getName(), right.getName()) && Objects.equals(left.getIn(), right.getIn());
    }

    public Optional<ChangedParameters> diff(List<Parameter> left, List<Parameter> right, DiffContext context) {
        ChangedParameters changedParameters = new ChangedParameters(left, (List<Parameter>)(right != null ? new ArrayList<Parameter>(right) : null), context);
        if (null == left) {
            left = new ArrayList<Parameter>();
        }
        if (null == right) {
            right = new ArrayList<Parameter>();
        }
        for (Parameter leftPara : left) {
            Optional<Parameter> rightParam = ParametersDiff.contains(this.rightComponents, right, leftPara = refPointer.resolveRef(this.leftComponents, leftPara, leftPara.get$ref()));
            if (!rightParam.isPresent()) {
                changedParameters.getMissing().add(leftPara);
                continue;
            }
            Parameter rightPara = rightParam.get();
            right.remove(rightPara);
            this.openApiDiff.getParameterDiff().diff(leftPara, rightPara, context).ifPresent(changedParameters.getChanged()::add);
        }
        changedParameters.getIncreased().addAll(right);
        return ChangedUtils.isChanged(changedParameters);
    }
}

