/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.model.ChangedOperation;
import org.openapitools.openapidiff.core.model.ChangedParameters;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.utils.ChangedUtils;

public class OperationDiff {
    private final OpenApiDiff openApiDiff;

    public OperationDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
    }

    public Optional<ChangedOperation> diff(Operation oldOperation, Operation newOperation, DiffContext context) {
        ChangedOperation changedOperation;
        block11: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                changedOperation = new ChangedOperation(context.getUrl(), context.getMethod(), oldOperation, newOperation);
                                this.openApiDiff.getMetadataDiff().diff(oldOperation.getSummary(), newOperation.getSummary(), context).ifPresent(changedOperation::setSummary);
                                this.openApiDiff.getMetadataDiff().diff(oldOperation.getDescription(), newOperation.getDescription(), context).ifPresent(changedOperation::setDescription);
                                this.openApiDiff.getMetadataDiff().diff(oldOperation.getOperationId(), newOperation.getOperationId(), context).ifPresent(changedOperation::setOperationId);
                                changedOperation.setDeprecated(!Boolean.TRUE.equals(oldOperation.getDeprecated()) && Boolean.TRUE.equals(newOperation.getDeprecated()));
                                if (oldOperation.getRequestBody() != null) break block6;
                                if (newOperation.getRequestBody() == null) break block7;
                            }
                            this.openApiDiff.getRequestBodyDiff().diff(oldOperation.getRequestBody(), newOperation.getRequestBody(), context.copyAsRequest()).ifPresent(changedOperation::setRequestBody);
                        }
                        this.openApiDiff.getParametersDiff().diff(oldOperation.getParameters(), newOperation.getParameters(), context).ifPresent(params -> {
                            this.removePathParameters(context.getParameters(), (ChangedParameters)params);
                            changedOperation.setParameters((ChangedParameters)params);
                        });
                        if (oldOperation.getResponses() != null) break block8;
                        if (newOperation.getResponses() == null) break block9;
                    }
                    this.openApiDiff.getApiResponseDiff().diff(oldOperation.getResponses(), newOperation.getResponses(), context.copyAsResponse()).ifPresent(changedOperation::setApiResponses);
                }
                if (oldOperation.getSecurity() != null) break block10;
                if (newOperation.getSecurity() == null) break block11;
            }
            this.openApiDiff.getSecurityRequirementsDiff().diff(oldOperation.getSecurity(), newOperation.getSecurity(), context).ifPresent(changedOperation::setSecurityRequirements);
        }
        this.openApiDiff.getExtensionsDiff().diff(oldOperation.getExtensions(), newOperation.getExtensions(), context).ifPresent(changedOperation::setExtensions);
        return ChangedUtils.isChanged(changedOperation);
    }

    public void removePathParameters(Map<String, String> pathParameters, ChangedParameters params) {
        pathParameters.forEach((oldParam, newParam) -> {
            this.removePathParameter((String)oldParam, params.getMissing());
            this.removePathParameter((String)newParam, params.getIncreased());
        });
    }

    public void removePathParameter(String name, List<Parameter> parameters) {
        parameters.stream().filter(p -> "path".equals(p.getIn()) && name.equals(p.getName())).findFirst().ifPresent(parameters::remove);
    }
}

